/**************************************
 *                                     *
 *        TITLE.C   ( NEW VERSION )    *
 *                                     *
 ***************************************
 *                                     *
 *       T.KOBAYASHI  07/12/89         *
 *                                     *
 **************************************/
#include <stdio.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"


int
main()
{
  char  *ialpha[3];
  int   i, j, k, num, ib, iflags;
  char   in[TITLE_LEN+1], cl[ONE_LINE];
  char  cls[TITLE_LEN+1], *title[3];
  static char  dc[3] = {'X', 'Y', 'Z'};
  
  read_syscom();
  regpm();
  
  ib = (int)GetScalar(0) -1;
  if ( ib < 0 || ib >= TITLE_MAX ) exit(2);
  iflags = 0;
  for ( i = 1; i < 4; i++ )
    ialpha[i-1] = GetString(i);

  title[0] = GpmCont.title_x[ib];
  title[1] = GpmCont.title_y[ib];
  title[2] = GpmCont.title_z[ib];

  if ( syscom.narg >= 4 && strcmp(GetArgType(3),"string") == 0 )
    strcpy(title[2],ialpha[2]);

  num = ( syscom.narg == 3 ) ? 2 : 3;
  for ( k = 0; k < num; k++ ) {
    if ( ialpha[k] == NULL || strlen(ialpha[k]) == 0 ) {
      strncpy(in, title[k], TITLE_LEN);
      in[TITLE_LEN] = EOS;
      printf("\nTITLE(%d) %c - AXIS \"%s\"\n", ib+1, dc[k], in );
      printf("                   ");
      fflush(stdout);
      for (i = 0; i < ONE_LINE; cl[i++] = 0x00);
      fgets(cl, ONE_LINE-1, stdin);
      if (cl[0] != EOS)
	for (i = 0; i < TITLE_LEN; i++) {
	  if (cl[i] < 0x20) {
	    j = i;
	    while (j < TITLE_LEN)
	      cl[j++] = 0x00;
	    break;
	  }
	}
      else
	iflags = 1;
      strncpy(cls, cl, TITLE_LEN );
    } else
      strncpy(cls, ialpha[k], TITLE_LEN );

    if ( iflags != 1 ) {
      if (  strlen(cls) == 0 || ( strlen(cls) == 1 && cls[0] == ' ' ))
	title[k][0] = '\0';
      else
	strcpy(title[k], cls);
    }
  }  
  
  write_syscom();
  wrgpm();
  return 0;
}
