#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
  
int
main()
{
  int       w_no;
  char     *pstr;
  char      str[FILE_LENGTH];
  FILE     *w_file;
  GpmWinID  win[MAX_WIN];
  int       closeall = 0;
  
  read_syscom();
  regpm();
  
  pstr = GetString(0);
  w_no = (int)GetScalar(0);
  
  if ( strcmp( pstr, "ALL") == 0 )
    closeall = 1;
  else {
    if (w_no < 1 || w_no > MAX_WIN)
      exit(35);
    w_no--;
  }
  
  strcpy(str, syscom.temp_dir);
  strcat(str, WIN_FNAME);
  
  if (access(str, 0) == -1) {
    exit(24);
  }

  w_file = fopen(str, "r+" );
  fread( (char *)win, sizeof(GpmWinID), MAX_WIN, w_file );
  
  if (closeall == 1) {
    for (w_no = 0; w_no < MAX_WIN; w_no++) {
      if (win[w_no].pid != 0 ) {
	if (win[w_no].pid != -1)
	  kill(win[w_no].pid, SIGUSR1);
	win[w_no].wid = (Window)0;
	win[w_no].pid = 0;
      }
    }
    GpmCont.winNum = -1;
  } else {
    if (win[w_no].pid != 0) {
      if (win[w_no].pid != -1)
	kill(win[w_no].pid, SIGUSR1);
      win[w_no].wid = (Window)0;
      win[w_no].pid = 0;
    } else {
      printf("Not exist window (No.%d)\n",w_no+1);
    }      
    for ( w_no = MAX_WIN-1; w_no >= 0 && win[w_no].pid == 0 ; w_no-- );
    GpmCont.winNum = w_no;
  }
  fseek( w_file, 0L , 0);
  fwrite( (char *)win, sizeof(GpmWinID), MAX_WIN, w_file );
  
  fclose(w_file);
  
  wrgpm();
  write_syscom();
  return 0;
}
