#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "SL_macro.h"
#include "SL_cmd.h"
#include "GPMdef.h"
#include "GPMwin.h"
  
#ifndef ALIGN_LEFT
#define ALIGN_LEFT   0
#define ALIGN_CENTER 1
#define ALIGN_RIGHT  2
#define ALIGN_TOP    0
#define ALIGN_MIDDLE 1
#define ALIGN_BOTTOM 2
#endif



int myDrawString _ANSI_ARGS_(( char *text, int x, int y,
			       int orient, int hpos, int vpos,
			       char *fontname ));

int main(argc, argv)
     int   argc;
     char *argv[];
{
  int    numer, orient = 0;
  float  rnumer[2] ;
  char  *ialpha[4];
  char   buf[ONE_LINE];
  int    hpos = 0, vpos = 0;

  read_syscom() ;
  regpm() ;

  rnumer[0] = (float) GetScalar(0);
  rnumer[1] = (float) GetScalar(1);
  ialpha[0] =         GetString(2);
  ialpha[1] =         GetString(3);
  ialpha[2] =         GetString(4);
  ialpha[3] =         GetString(5);
  numer     = (int)   GetScalar(6);
  if ( GetArgNum() > 7) 
    orient    = (int)   GetScalar(7); /* string orientation */
  if ( GetArgNum() > 8) 
    hpos      = (int)   GetScalar(8); /* h-alignment */
  if ( GetArgNum() > 9) 
    vpos      = (int)   GetScalar(9); /* v-alignment */
  
  if ( ialpha[0] == NULL )
    exit(2);

  gopen( GpmCont.paper, GpmCont.orientation, GpmCont.device,
	GpmCont.winNum ) ;
  gnewpen( GpmCont.fColor ) ;
  gpen( GpmCont.fLineWidth, GpmCont.fLineType, 0 );
  gorigin( GpmCont.xOrigin, GpmCont.yOrigin ) ;
  gfactor( GpmCont.factor ) ;

  *buf='\0';
  
  if ((strcmp("times",ialpha[1])==0)||
      (strcmp("helvetica",ialpha[1])==0)||
      (strcmp("courier",ialpha[1])==0)) {
    
    if ((strcmp("bold",ialpha[2])==0)||(strcmp("medium",ialpha[2])==0)) {
      
      if (((strcmp("helvetica",ialpha[1])==0)||
	   (strcmp("courier",ialpha[1])==0))&&
	  (strcmp("i",ialpha[3])==0)) strcpy(ialpha[3],"o");
      
      if ((strcmp("times",ialpha[1])==0)&&(strcmp("o",ialpha[3])==0))
	strcpy(ialpha[3],"i");
      
      if ((strcmp(ialpha[3],"r")==0)||
	  (strcmp(ialpha[3],"i")==0)||
	  (strcmp(ialpha[3],"o")==0)) {
	
	switch ( numer ) {
	  
	case 8: case 10: case 11: case 12: case 14: case 17:
	case 18: case 20: case 24: case 25: case 34:
	  sprintf(buf,"-adobe-%s-%s-%s-normal--%d-*-*-*-*-*-iso8859-1",
		  ialpha[1],ialpha[2],ialpha[3],numer );
	  break;
	}
      }
    }
  }
  if (*buf=='\0')
    strcpy(buf,"-adobe-times-bold-r-normal--14-*-*-*-*-*-iso8859-1");
	      
  myDrawString(ialpha[0],
	       (int)((rnumer[0]+mgraph.xorg)*mdev.ffx),
	       mdev.iyleng-(int)((rnumer[1]+mgraph.yorg)*mdev.ffy),
	       orient, hpos, vpos, buf);

  gflush();
  gclose() ;

  wrgpm() ;
  write_syscom() ;
  return 0;
}



int myDrawString( text, x, y, orient, hpos, vpos, fontname )
     char   *text;
     int    x, y;
     int    orient;
     int    hpos, vpos;
     char   *fontname;
{
  GC            local_gc, agc, bgc;
  Pixmap        pixmap1, pixmap2;
  XImage        *Image1, *Image2;
  XFontStruct   *font;

  unsigned int  desc;
  unsigned long valuemask, pixel;

  int  i, j, xoff=0, yoff=0;
  int  textwidth, textheight;
  int  drawwidth, drawheight;
  int  pix_x, pix_y, pre_x, pre_y;
  int  Cos = 0, Sin = 0;

  local_gc  = XCreateGC(gpm_display, gpm_window, 0, 0);
  valuemask = GCForeground | GCBackground | GCFunction;
  XCopyGC(gpm_display, gpm_gc, valuemask, local_gc);

  font       = XLoadQueryFont(gpm_display,fontname);
  textwidth  = XTextWidth( font, text, strlen(text));
  /*    + font->max_bounds.lbearing + font->max_bounds.rbearing; */
  
  textheight = font->max_bounds.ascent + font->max_bounds.descent;
  desc       = font->max_bounds.descent;

  switch(orient%4) {
  default:
  case 0: /* normal left to right */
    drawwidth  = textwidth;
    drawheight = textheight;
    Cos = 1;
    Sin = 0;
    break;
  case 1: /* bottom to top */
    drawwidth  = textheight;
    drawheight = textwidth;
    Cos = 0;
    Sin = 1;
    break;
  case 2: /* right to left */
    drawwidth  = textwidth;
    drawheight = textheight;
    Cos = -1;
    Sin = 0;
    break;
  case 3: /* top to bottom */
    drawwidth  = textheight;
    drawheight = textwidth;
    Cos = 0;
    Sin = -1;
    break;
  }

  switch( hpos%3 ){
  case ALIGN_LEFT:
  default:
    xoff = textwidth/2;  break;
  case ALIGN_CENTER:  xoff = 0; break;
  case ALIGN_RIGHT:   xoff = -textwidth/2;   break;
  }
  switch( vpos%3 ){
  case ALIGN_TOP:
  default:
      yoff = textheight/2;   break;
  case ALIGN_MIDDLE:  yoff = 0; break;
  case ALIGN_BOTTOM:  yoff = - textheight/2; break;
  }

  x = x + xoff*Cos -yoff*Sin - drawwidth/2;
  y = y - xoff*Sin -yoff*Cos - drawheight/2;

  pixmap1 = XCreatePixmap( gpm_display, gpm_window, textwidth, textheight, 1 );
  pixmap2 = XCreatePixmap( gpm_display, gpm_window, drawwidth, drawheight, 1 );

  bgc = XCreateGC( gpm_display, pixmap1, 0, 0 );
  XSetForeground( gpm_display, bgc, 0 );

  agc = XCreateGC( gpm_display, pixmap1, 0, 0 );
  XSetFont( gpm_display, agc, font->fid );
  XSetForeground( gpm_display, agc, 1 );
  XSetBackground( gpm_display, agc, 0 );

  XFillRectangle( gpm_display, pixmap1, bgc, 0, 0, textwidth, textheight );
  XFillRectangle( gpm_display, pixmap2, bgc, 0, 0, drawwidth, drawheight );

  XDrawString(gpm_display,pixmap1,agc, 0,
	      font->max_bounds.ascent-1, text,strlen(text));

  Image1 = XGetImage( gpm_display, pixmap1, 0, 0, textwidth, textheight, 
                     AllPlanes, XYPixmap );
  Image2 = XGetImage( gpm_display, pixmap2, 0, 0, drawwidth, drawheight, 
                     AllPlanes, XYPixmap );

  switch (orient%4) {
  case 0:
    XPutImage( gpm_display, pixmap2, agc, Image1, 0, 0,
              0, 0, drawwidth, drawheight );     

    break;
  default:
    for ( i=0 ; i<textwidth; i++ ) {
      for ( j=0 ; j<textheight; j++ ) {
        if (( pixel = XGetPixel( Image1, i, j ) ) == 0 )
          continue;
        
        pre_x = i - textwidth/2;
        pre_y = textheight/2 - j;
        
        pix_x = pre_x * Cos - pre_y * Sin;
        pix_y = pre_x * Sin + pre_y * Cos;
        
        pix_x += drawwidth/2;
        pix_y  = drawheight/2 - pix_y;
        XPutPixel( Image2, pix_x, pix_y, pixel );
      }
    }
    XPutImage( gpm_display, pixmap2, agc, Image2, 0, 0,
	       0, 0, drawwidth, drawheight );
    break;
  }

  XSetStipple(   gpm_display,  local_gc,    pixmap2 );
  XSetTSOrigin(  gpm_display,  local_gc,    x, y );
  XSetFillStyle( gpm_display,  local_gc,    FillStippled );
  XSetFunction(  gpm_display,  local_gc,    GXcopy );

  XFillRectangle( gpm_display, gpm_window, local_gc,
		  x, y, drawwidth, drawheight );
  XFillRectangle( gpm_display, gpm_pixmap, local_gc,
		  x, y, drawwidth, drawheight );


  XDestroyImage( Image1 );
  XDestroyImage( Image2 );

  XFreePixmap( gpm_display, pixmap1 );
  XFreePixmap( gpm_display, pixmap2 );

  XFreeGC( gpm_display, agc );
  XFreeGC( gpm_display, bgc );
  XFreeGC( gpm_display, local_gc );

  return 0;
}
