/******************************************************************
**      File Name : SL_cmd.h                                     **
**                                                               **
**        Header for SATELLITE COMMAND PROCEDURE                 **
**                                Coded by Shigeru Hitomi        **
**                                                               **
******************************************************************/

#ifndef _SL_CMD_H_
#define _SL_CMD_H_

#ifndef _SL_MACRO_H_
#include "SL_macro.h"
#endif

#define NARG		16
#define	ENV_VAR_LENGTH	20
#define STR_LENGTH	32	/* One Parameter Length */

/* Old File Type */
#undef  OLD_BIG_ENDIAN
#undef  OLD_LITTLE_ENDIAN
#define OLD_BIG_ENDIAN	        0	/* WS : SPARC, LUNA88K, TITAN */
#define OLD_LITTLE_ENDIAN	1	/* PC : PC98               */

/* New File Type */
#undef  BigEndian
#undef  LittleEndian
#define BigEndian       2	/* cpu type : 680x0 (SPARC, LUNA88K, TITAN) */
#define LittleEndian    3	/* cpu type : 80x86 (PC98, IBM-PC)          */ 

#define WhatType	-1

/***** System Common Area Read/Write Function *****/
#define recom1()        resat()
#define wrcom1()        wrsat()
#define resat()		read_syscom()
#define wrsat()		write_syscom()


/***********************************************************************
------------------ Structure of System Common Area ---------------------
************************************************************************/

typedef struct sys_common {
	/******************************************************/
	/*              Temporary Directory                   */
	/******************************************************/
	char            temp_dir[FILE_LENGTH];

	/******************************************************/
	/* System Parameter Information             */
	/******************************************************/
	int             buff_leng;	/* Length of One Data Buffer         */
	double          sam_freq;	/* Sampling Frequency                */
	int             err_flag;	/* Error Flag from Command Procedure */

	/******************************************************/
	/*              Parameters Information                */
	/******************************************************/
	/* Number of Parameters	 */
	int             narg;	/* narg <= NARG    */
	int             parm_num;	/* narg == parm_num */
	/* parm_num : compatible for older version */

	/* Value Information */
	char		types[NARG][10];
	char            strings[NARG][ONE_LINE];
	double          values[NARG];

	/******************************************************/
	/*        Return Value from Command Procedure         */
	/******************************************************/
	/* serial number of internal buffer */
	int             buffer_number;

	/* type : "scalar", "string", "series", "snapshot" */
	char            return_type[20];
	char            return_strings[NARG][ONE_LINE];
	double          return_values[NARG];

} SystemCommon;

/***********************************************************************
------------------ Structure of Data File Format  ----------------------
************************************************************************/

#define REC_SIZE        256	/* System Parameter Record Length[byte] */


/***** SATELLITE OLD Data File Header *****/
typedef struct {
	short           type_flag;	/* File Format Flag            */
	short           data_flag;	/* Data Type Flag              */
	char            opr_name[20];	/* Operator Name               */
	char            comment[200];	/* Comment Area	               */
	char            con_file[10];	/* Relational File             */
	short           date[3];        /* Operation Date              */
	float           samf;           /* Sampling Freq               */
	unsigned short  rec_leng;	/* Block / 1 Record            */
	unsigned short  rec_num;        /* Total Records               */
	unsigned short  data_num;	/* Number of Data / 1 Records  */
	short           dummy[3];
}               h_type;

/***** SATELLITE-LANG New Data File Header *****/
typedef struct {
	char            type_flag;	/* File Format Flag            */
	char            data_size;	/* Size of a data              */
	char            opr_name[30];	/* Operator Name               */
	char            comment[128];	/* Comment Area	               */
	char            date[3];        /* Date of Making              */
	char            dim;	        /* Dimension                   */
	int             index[10];	/* Number of Data              */
	float           samf;	        /* Sampling Frequency          */
	char            free[48];	/* free area                   */
}               Header;

/* following valuable is declared in syscom.c */
#ifndef _LIB_SYSCOM_C_
extern SystemCommon  syscom;
#endif

#endif /* _SL_CMD_H_ */
