/*********************************************************************
	SL_macro.h :
**********************************************************************/

#ifndef _SL_MACRO_H_
#define _SL_MACRO_H_

#ifndef HAVE_CONFIG_H
#include "SL_config.h"
#endif
#include "SL_dirs.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif


#define RC_FILE         "rc.sl"
#define SETUP_FILE      ".setup.sl"
#define CLEAN_FILE      ".clean.sl"
#define HIST_FILE       ".history.sl"
#define ERROR_LOG       "sl.err.log"

#define ONELINE		1024     /* only use in SHELL */
#define ONE_LINE	512      /* this affect communication of
				    all user commands */

#define PATHLEN		512
#define DIR_LENGTH	PATHLEN

#define FILE_LENGTH     512       /* this also affect communication of
				    all user commands */

#define ARGC  20
#define ARG   ARGC



#define NAMELEN		64

#ifndef ESC
#define ESC	0x1b
#endif
#ifndef TRUE
#define TRUE    (1)
#endif
#ifndef	FALSE
#define FALSE   (0)
#endif
#define TELL	(-1)
#define MORE	(-1)
#ifndef EOS
#define EOS	0
#endif

#define MAX_INDEX 10
#define MAX_BUFF_DIM 5
#define MAX_BUFF_MON 20
#define	INPUT(A,B,C,D)	_input_(A,B,C,D)


#define equal(a,b)	(!strcmp(a,b))
#ifndef Min
#define Min(a,b)       ((a) < (b) ? (a) : (b))
#endif
#ifndef Max
#define Max(a,b)       ((a) > (b) ? (a) : (b))
#endif

#ifdef HAVE_MEMSET
#define Bzero(s1,siz)		memset((char *)(s1), 0, siz)
#else
#define Bzero(s1,siz)		bzero((char *)(s1),siz)
#endif

#ifndef SEEK_SET
#define SEEK_SET        0       /* Set file pointer to "offset" */
#define SEEK_CUR        1       /* Set file pointer to current plus "offset" */
#define SEEK_END        2       /* Set file pointer to EOF plus "offset" */
#endif



typedef double  Buffer;

#ifndef _SL_CMD_H_
#include "SL_cmd.h"
#endif
#include "SL_prototype.h"

#endif	/* _SL_MACRO_H_ */
/*********************************************************************
	End of macro
**********************************************************************/
