#ifndef _SL_PROTOTYPE_H_
#define _SL_PROTOTYPE_H_

#undef _ANSI_ARGS_
#if ( defined(__STDC__) && !defined(NO_PROTOTYPE)) || defined(USE_PROTOTYPE)
#   define _USING_PROTOTYPES_ 1
#   define _ANSI_ARGS_(x)       x
#   define CONST const
#else
#   define _ANSI_ARGS_(x)       ()
#   define CONST
#endif

/* in syscom.c */
extern int      make_syscom        _ANSI_ARGS_((void));
extern int      init_syscom        _ANSI_ARGS_((void));
extern int      free_syscom        _ANSI_ARGS_((void));
extern int      NextBuffer         _ANSI_ARGS_((void));
extern int      set_mypid          _ANSI_ARGS_((int pid));
extern int      set_tmpdir         _ANSI_ARGS_((char *dir));
extern int      set_sampling       _ANSI_ARGS_((double freq));
extern char    *get_tmpdir         _ANSI_ARGS_((void));
extern double   get_sampling       _ANSI_ARGS_((void));
extern int      read_syscom        _ANSI_ARGS_((void));
extern int      write_syscom       _ANSI_ARGS_((void));

/* in buffer.c */
extern Buffer  *AllocBuffer        _ANSI_ARGS_((unsigned buf_size));
extern Buffer  *CAllocBuffer       _ANSI_ARGS_((unsigned buf_size));
extern int      FreeBuffer         _ANSI_ARGS_((Buffer *area));
extern int      DestroyBuffer      _ANSI_ARGS_((int n));
extern int      InitBuffer         _ANSI_ARGS_((int n, int dim, int *idx));
extern Buffer  *ReadBuffer         _ANSI_ARGS_((int n, int *dim, int *idx));
extern int      WriteBuffer        _ANSI_ARGS_((int n, int dim, int *idx,
						Buffer *area));
extern Buffer  *ReadSubBuffer      _ANSI_ARGS_((int n, int time,
						int *sub_dim, int *sub_idx));
extern int      WriteSubBuffer     _ANSI_ARGS_((int n, int time, int sub_dim,
						int *sub_idx, Buffer *area));
extern int      AppendBuffer       _ANSI_ARGS_((int n, int sub_dim,
						int *sub_idx, Buffer *area));
extern Buffer  *ReadTimeSeries     _ANSI_ARGS_((int n, int sub_dim,
						int *sub_idx, int *length));
extern int      WriteTimeSeries    _ANSI_ARGS_((int n, int sub_dim,
						int *sub_idx, Buffer *area,
						int length));
extern int      GetBufferInfo      _ANSI_ARGS_((int n, int *idx));
extern int      BufferErrorNo      _ANSI_ARGS_((void));
extern char    *BufferErrorMessage _ANSI_ARGS_((void));

/* in rwfile.c */
extern int      ChangeDataType     _ANSI_ARGS_((int type));
extern int      ChangeDataSize     _ANSI_ARGS_((int siz));
extern char    *ReadFile           _ANSI_ARGS_((char *f_name, Header *head));
extern int      WriteFile          _ANSI_ARGS_((char *f_name, int dim,
						int *idx, char *data));
extern char    *LoadData           _ANSI_ARGS_((char *f_name, int numb,
						Header *head));
extern int      StoreData          _ANSI_ARGS_((char *f_name, int numb,
						int dim, int *idx,
						char *data));
extern void     PrintHeader        _ANSI_ARGS_((Header *head));
extern void     InitHeader         _ANSI_ARGS_((Header *head));
extern int      LoadHeader         _ANSI_ARGS_((char *fname, Header *head));
extern int      StoreHeader        _ANSI_ARGS_((char *fname, Header *head));

/* in u_info.c */
extern char    *getusername        _ANSI_ARGS_((char *name, int siz));
extern char    *gethomedir         _ANSI_ARGS_((char *dir, int siz));
extern void     get_date           _ANSI_ARGS_((int *year, int *month,
						int *day));
extern void     get_time           _ANSI_ARGS_((int *hour, int *minute,
						int *second));

/* in numget.c */
extern char    *getnum             _ANSI_ARGS_((char *stream));

/* in index.c */
extern int      RegularIndex       _ANSI_ARGS_((int *idx2, int *idx, int n));
extern int      CopyIndex          _ANSI_ARGS_((int *to, int *from, int n));
extern int      EqualIndex         _ANSI_ARGS_((int *to, int *from, int n));
extern int      IndexSize          _ANSI_ARGS_((int dim, int *idx));
extern int     *SubIndex           _ANSI_ARGS_((int *idx));
extern int      Index              _ANSI_ARGS_((int *idx2, int dim, int *idx));
extern int     *rIndex             _ANSI_ARGS_((int n, int *idx2,
						int dim, int *idx));
extern void     MaxIndex           _ANSI_ARGS_((int *a, int *b,
						int *idx, int dim));
extern void     MinIndex           _ANSI_ARGS_((int *a, int *b,
						int *idx, int dim));
/* in bcopy.c */
extern void     Bcopy              _ANSI_ARGS_((char *src, char *dst,
						int length));
/* in rwfile.old.c */
extern void     m_file             _ANSI_ARGS_((char *f_name));
extern int      r_file             _ANSI_ARGS_((int s_blk, int num_blk,
						char *f_name, char *data));
extern int      w_file             _ANSI_ARGS_((int s_blk, int num_blk,
						char *f_name, char *data));
extern void     stor_init          _ANSI_ARGS_((char *f_name, int type));
extern int      stor_data          _ANSI_ARGS_((float *data, int d_point,
						char *f_name, int numb));
extern int      load_data          _ANSI_ARGS_((float *data, char *f_name,
						int numb));
extern void     stor_header        _ANSI_ARGS_((char *f_name, h_type *head));
extern int      load_header        _ANSI_ARGS_((char *f_name, h_type *head));

#ifndef _DEFS_H_
/* in protocol.c */
extern int      GetArgNum      _ANSI_ARGS_((void));
extern char    *GetArgType     _ANSI_ARGS_((int n));
extern int      GetBufferID    _ANSI_ARGS_((int n));
extern char    *GetString      _ANSI_ARGS_((int n));
extern double   GetScalar      _ANSI_ARGS_((int n));
extern Buffer  *GetSeries      _ANSI_ARGS_((int n, int *dim, int *idx));
extern Buffer  *GetSnapshot    _ANSI_ARGS_((int n, int *dim, int *idx));
extern void     ReturnSeries   _ANSI_ARGS_((Buffer *buf, int dim, int *idx));
extern void     ReturnScalar   _ANSI_ARGS_((double sc));
extern void     ReturnSnapshot _ANSI_ARGS_((Buffer *buf, int dim, int *idx));
extern void     ReturnString   _ANSI_ARGS_((char *str));

/* in emalloc.c,
   emalloc, erealloc, and efree are also in SHELL/misc.c and
   have same prototypes, but these are little bit different functions */
extern char    *emalloc        _ANSI_ARGS_((unsigned n));
extern char    *erealloc       _ANSI_ARGS_((char *p, unsigned n));
extern void     efree          _ANSI_ARGS_((char *p));

/* in qsort.c */
extern void     sort           _ANSI_ARGS_((float *a, float *idx, int n));

/* in buffer.old.c */
extern float   *buff_alloc     _ANSI_ARGS_((void));
extern void     buff_free      _ANSI_ARGS_((float *p));
extern int      buff_init      _ANSI_ARGS_((int n, int dim, int *idx));
extern int      buff_write     _ANSI_ARGS_((int n, float *area,
					  int length, int *idx));
extern int      buff_read      _ANSI_ARGS_((int n, float *area, int *idx));
#if 0
extern int      buff_info      _ANSI_ARGS_((int n, int *idx));
#endif
extern void     buff_append    _ANSI_ARGS_((int n, float *area, int length));

/* in get_p.c, old style API */
extern int      get_p          _ANSI_ARGS_((int nprm, int str_size,
					    char *str, int *integer,
					    float *real));
/* in input.y, it seems not used now. */
extern int     _input_         _ANSI_ARGS_((int str_size, char *str,
					    int *integer, float *real));

#endif /* !_DEFS_H_ */
#endif /* _SL_PROTOTYPE_H_ */
