#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*********************************************
 *  y = akima( B1, B2, B3 [, B4])            * 
 *            B1 : INPUT TIME BUFFER         *
 * 	      B2 : INPUT DATA BUFFER         *
 *            B3 : DPT or OUTPUT TIME PRESET *
 *            B4 : OUTPUT TIME BUFFER        *
 *            Y  : OUTPUT DATA BUFFER        *
 *********************************************/
static int     akima _ANSI_ARGS_((Buffer *tin,  Buffer *din,  int n,
				  Buffer *tout, Buffer *dout, int dpt));
static double  ak    _ANSI_ARGS_((double *x, int k));

#define SQR(a)  ((a)*(a))

int
main()
{
  int      args    = 0;
  int      dimx, idxx[MAX_INDEX];
  int      dimy, idxy[MAX_INDEX];
  int      dimo, idxo[MAX_INDEX]; 
  int      outx_id = 0;
  int      i, n, fmode = 0, imode = 0;
  int      dpt = 0;
  Buffer  *xxa, *yya, *xa, *ya, DI;
  Buffer  *xo = NULL, *yo = NULL;

  read_syscom();
	
  args = GetArgNum();

  dimx = GetBufferInfo(GetBufferID(0), idxx);
  dimy = GetBufferInfo(GetBufferID(1), idxy);

  if ( dimx != 1 ) exit(24);
  if ( dimx != dimy || idxx[0] != idxy[0] )
    exit(16);

  n = idxx[0];

  /* 1: xǡɤ߹ */
  if (( xxa = GetSeries(0, &dimx, idxx )) == NULL ) exit(4);
  if (( xa  = CAllocBuffer(IndexSize(dimx,idxx)+4) ) == NULL ) exit(8);
  for ( i = 0; i < n; i++ )
    xa[i+2] = xxa[i]; /* +2 ƤΤϡakima ˡξü
			 2ΰɬפȤ뤿 */
  FreeBuffer(xxa); /* xa ˥ԡ顤xxa Ϥ⤦ʤ */

  for ( i = 2; i < n+1; i++ )
    if ( xa[i] >= xa[i+1] ) exit(26); /* xa[i] < xa[i+1] ǤʤХ */

  /* 2: yǡɤ߹ */
  if (( yya = GetSeries(1, &dimy, idxy )) == NULL ) exit(4);
  if (( ya  = CAllocBuffer(IndexSize(dimy,idxy)+4) ) == NULL ) exit(8);
  for ( i = 0; i < n; i++ ) ya[i+2] = yya[i];
  FreeBuffer(yya);

  /* 3 series ξϡо x ηˤ */
  if ( strcmp(GetArgType(2),"series") == 0 ) {
    if ((xo  = GetSeries(2, &dimo, idxo )) == NULL ) exit (17);
    if ( dimo != 1  ) exit(24);
    dpt = idxo[0];

    for ( i = 0; i < dpt-1; i++ )
      /* x[i] < x[i+1] ǤʤХäƤȤϤʤɤ줷ʤΤǥ */
      if ( xo[i] >= xo[i+1] )
	exit(26); 
    imode = 0;
  } else {
    /* 3 scalar ξϡָ y ΥǡȤ
     * xa[0], xa[n-1] Ȥ x ˤ롥
     * < 0 ξϡץ󥰼ȿȤ x  */
    dimo  = 1;
    dpt   = (int)GetScalar(2);
    imode = 1;
  }
  if ( args > 3 ) {
    /* 4ˤϡ֥ǡ y б x Ǽ
       Хåեˤ */
    if (( outx_id = GetBufferID(3) ) <= 0 ) exit(17);
    if ( imode == 1 ) imode = 2;
  }

  if ( dpt <= 0 ) {
    fmode = 1;
    dpt   = (int)((xa[n+1]-xa[2])*get_sampling()) + 1;
  }
  
  if ((yo = CAllocBuffer(dpt)) == NULL) exit(8);

  if ( imode != 0 ) {
    if ((xo  = CAllocBuffer(dpt)) == NULL ) exit(8);

    DI = (fmode) ? 1.0/get_sampling() : 
      ((dpt > 1) ? (xa[n+1]-xa[2])/(double)(dpt-1) : 0.0);
    for ( i = 0; i < dpt; i++ )
      xo[i] = (double)i * DI + xa[2];
  }

  if ( xa[2] > xo[0] || xa[n+1] < xo[dpt-1]) exit(27); /* domain error */
  if ( akima(xa, ya, n, xo, yo, dpt) != 0 )  exit(25);

  idxo[0] = dpt;
  ReturnSeries( yo, dimo, idxo );
  if ( outx_id > 0 )
    if ((WriteBuffer( outx_id, dimo, idxo, xo )) == -1 ) exit(3);

  write_syscom();
  return 0;
}


/***** Akima Hokanhou *****/
static int akima(Buffer *tin, Buffer *data, int n, Buffer *tout, 
		 Buffer *dout, int dpt){
  double   c1, c2, x[4];
  int      i, j;
  double  *m  = CAllocBuffer(n+4);
  double  *t  = CAllocBuffer(n+4);
  double  *a2 = CAllocBuffer(n+4);
  double  *a3 = CAllocBuffer(n+4);

  if ( m == NULL || t == NULL || a2 == NULL || a3 == NULL ) return -1;
  if ( n < 3 ) return -1;

  /* preparation of data */
#if 0 /* already rotated, does not require now */
  for( i = n-1; i >= 0; i-- ) { /* rotate to center */
    data[i+2] = data[i];
    tin [i+2] = tin[i];
  }
#endif

  tin[0]   = 2*tin[2] - tin[4];
  tin[1]   = tin[2] + tin[3] - tin[4];

  tin[n+2] = tin[n+1] + tin[n] - tin[n-1];
  tin[n+3] = 2*tin[n+1] - tin[n-1];

  for( i = 1; i < 4; i++ ) x[i] = tin[i+1];
  for( i = 0; i < 2; i++ ) {
    data[i] = 0.0;
    x[0] = tin[i];
    for( j = 1; j < 4; j++ ) data[i] += ak(x,j) * data[j+1];
  }

  for( i = 1; i < 4; i++ ) x[i] = tin[n+i-2];
  for( i = 0; i < 2; i++ ) {
    data[n+2+i] = 0.0;
    x[0] = tin[n+2+i];
    for( j = 1; j < 4; j++ ) data[n+2+i] += ak(x,j) * data[n-2+j];
  }


  /* calculation */

  for( i = 0; i < n+3; i++ )
    m[i] = (data[i+1] - data[i])/(tin[i+1] - tin[i]);

  for( i = 2; i < n+3; i++ ) {
    c1 = fabs( m[i+1] - m[i] );
    c2 = fabs( m[i-1] - m[i-2] );
    if( c1 == 0.0 && c2 == 0.0 )
      t[i] = ( m[i-1] + m[i] ) / 2.0;
    else
      t[i] = ((c1 * m[i-1]) + (c2 * m[i]))/(c1 + c2);
  }

  for( i = 2; i < n+2; i++ ) {
    a2[i]  =  ( 3*m[i] -  2*t[i] - t[i+1] ) /  (tin[i+1]-tin[i]);
    a3[i]  =  ( t[i] + t[i+1] - 2*m[i] ) /  SQR(tin[i+1]-tin[i]);
  }

  for( i = 0, j = 2; j < n+2 && i < dpt; j++ ) {
    while( i < dpt && (tout[i] >= tin[j]) && (tout[i] <= tin[j+1]) ) { 
      c1       = tout[i] - tin[j];
      dout[i]  = ((( a3[j]*c1 ) + a2[j])*c1 +t[j])*c1 + data[j];
      i++;
    }
  }
#if 0
  for( i = 0; i < n; i++ ) { /* what is this ? */
    data[i] = t[i+2];
  }
#endif

  FreeBuffer(m);
  FreeBuffer(t);
  FreeBuffer(a2);
  FreeBuffer(a3);

  return 0;
}

static double ak(double *x,int k){
  int	  i;
  double  a;

  for( a = 1.0, i = 1; i < 4; i++ ) {
    if( i != k ) {
      a *= (( x[0] - x[i] ) / ( x[k] - x[i] ));
    }
  }
  return(a);
}
