#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "rand_sub.h" /* by okumura */

/**********************************************************
 * 
 * "ARAND  DPT , INIT , DISTRY , RMIN , RMAX "
 * 
 * DPT    : output data point
 * INIT   : initial value
 * DISTRY : distribution function's value
 * RMIN   : minimum of distribution function's range
 * RMAX   : maximum of distribution function's range
 *	
 *    Date May 26th, 1994 by DORA(T.Hayasaka)
 ***********************************************************/

int
main()
{
  int          dpt, fdpt;
  int          init, ii;
  Buffer       *distri;
  Buffer       lower, upper, rmax, rmin, dx;
  Buffer       *work, *awork, *xwork;
  register int i;
  int          dim = 1, index[MAX_INDEX];
  int          dim_dist, index_dist[MAX_INDEX];
  
  int          M[521], J;
  
  read_syscom();

  index[0] = dpt = (int)GetScalar(0);
  init = (int)GetScalar(1);
  distri = GetSeries(2,&dim_dist,index_dist);
  rmin = GetScalar(3);
  rmax = GetScalar(4);

  fdpt = index_dist[0];
  if (( awork = AllocBuffer(dpt) ) == NULL )
    exit(4);
  if (( work = AllocBuffer(dpt) ) == NULL )
    exit(4);
  if (( xwork = AllocBuffer(fdpt) ) == NULL )
    exit(4);

  dx = (rmax - rmin) / (Buffer)fdpt;
  xwork[0] = dx + rmin;
  for (i = 1; i < fdpt; i++){
    xwork[i] = xwork[i-1] + dx;
  }
  Gen_M_series(init, M);
  J = 0;
  
#ifdef DEBUG
  for (i = 0; i < 521; i++)
    printf("M series :%5d \n", M[i]);
#endif
  
  lower = 0.0;
  upper = 1.0;
  for (i = 0; i < dpt; i++) {
    work[i] = rnd_uni(lower, upper, M, &J);
  }
  for (i = 0; i < dpt; i++) {
    ii = 0;
    do{
      ii++;
    }
    while(work[i] > distri[ii]);
    if (work[i] == distri[ii]) {
      awork[i] = xwork[ii];
    }else{
      awork[i]=((work[i]-distri[ii-1])/(distri[ii]-distri[ii-1]))*dx+xwork[ii-1];
    }
  }
  ReturnSeries(awork, dim, index);
  FreeBuffer(awork);
  FreeBuffer(xwork);
  FreeBuffer(work);
  write_syscom();
  return 0;
}
