#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/****************************
*        AVERAGE            *
****************************/
int
main()
{
  int    leng, dim, idx[MAX_INDEX];
  register double *dat;
  Buffer *data, *max;
  Buffer ave;
  
  /***** Load System Parameter *****/
  read_syscom();

  if (( data = GetSeries(0, &dim, idx) ) == NULL )
    exit(4);
  
  leng = IndexSize(dim, idx);
  max = data + leng;
  
  ave = 0.0;
  for ( dat = data; dat < max; dat++) ave += (*dat);

  ave /= (double) leng;
  
  /***** Store System Parameter *****/
  ReturnScalar(ave);
  return 0;
}
