#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

/*****************************************************
*      complex cepstrum program                      *
*----------------------------------------------------*
*      cep  buf1,buf2,buf3,buf4                      *
*           buf1 -- input buffer( real )             *
*           buf2 -- input buffer( imag )             *
*           buf3 -- output buffer( real )            *
*           buf4 -- output buffer( imag )            *
*----------------------------------------------------*
*         1986 , 7 , 17    revised 1988,9,30         *
*         1993 , 4 , 19 by Take                      *   
******************************************************/

#define PAI	M_PI

extern int  fft1  _ANSI_ARGS_((double *ar, double *ai, int n, int flag ));


int
main()
{
  Buffer *workr, *worki, *wr, *wi, *max;
  int	 i, infd1, infd2, iofd1, iofd2, nod, n2;
  int    dim1, dim2, index1[MAX_INDEX], index2[MAX_INDEX];
  Buffer phps, phng, phase;
  Buffer pstphs, cdata, comp1, comp2, comp3;
  Buffer phs0, phs1;
  
  /***** Load System Parameter *****/
  read_syscom();
  
  /***** Initial Set *****/
  
  infd1 = GetBufferID(0);
  infd2 = GetBufferID(1);
  iofd1 = GetBufferID(2);
  iofd2 = GetBufferID(3);
  
  /***** Buffer -> Work Area *****/

  if ( iofd1 <= 0 || iofd2 <= 0 )
    exit(3);

  if (( workr = ReadBuffer( infd1, &dim1, index1 ) ) == NULL )
    exit(4);

  nod = IndexSize( dim1, index1 );
  if ( infd2 == 0 ) {
    if (( worki = AllocBuffer(nod) ) == NULL )
      exit(8);
    max = worki+nod;
    for( wi = worki; wi < max; wi++ )
      (*wi) = 0.0;
  } else{
    if (( worki = ReadBuffer( infd2, &dim2, index2 ) ) == NULL )
      exit(4);
    if ( IndexSize( dim2, index2 ) != nod )
      exit(18);
  }
  /***** FFT *****/
  fft1( workr, worki, nod, 0 );
  
  /***** Complex Log & Phase Unwrapping *****/
  phps = 0.0;
  phng = 0.0;
  
  cdata = workr[0];
  workr[0] = log( sqrt( workr[0] * workr[0] + worki[0] * worki[0]));
  worki[0] = atan2( worki[0], cdata );
  phase = worki[0];

  max = workr+nod;
  for( wr = workr+1, wi = worki+1; wr < max; wr++, wi++ ) {
    cdata = (*wr);
    (*wr) = log( sqrt( (*wr)*(*wr) + (*wi)*(*wi)) );
    (*wi) = atan2( (*wi), cdata );
    phase = (*wi);
    
    pstphs = (*wi-1) - phps + phng;
    comp1 = fabs( phase - pstphs );
    comp2 = fabs( phase - pstphs + 2.0 * PAI );
    comp3 = fabs( phase - pstphs - 2.0 * PAI );
    if( comp1 > comp2 )
      phps += ( 2.0 * PAI );
    if( comp1 > comp3 )
      phng += ( 2.0 * PAI );
    phase += ( phps - phng );
    
    (*wi) = phase;
  }
  
  /***** Remove Linear Conponent *****/
  phs0 = worki[0];
  n2 = nod / 2;
  phs1 = worki[n2];
  for( wi = worki, i = 0; i < nod; i++, wi++ ) {
    phase = (*wi);
    phase -= ( (double)i*( phs1 - phs0 )/(double)n2 + phs0 );
    worki[i] = phase;
  }
  
  /***** IFFT *****/
  fft1( workr, worki, nod, -1 );
  
  /***** Work Buffer -> Buffer *****/
  if ( WriteBuffer( iofd1, dim1, index1, workr ) == -1 )
    exit(3);
  if ( WriteBuffer( iofd2, dim1, index1, worki ) == -1 )
    exit(3);
  
  write_syscom();
  return 0;
}
