#include <math.h>
#include "Complex.h"

ComplexValue cplx( double i, double j )
{
  ComplexValue k;
  k.real = i;
  k.imag = j;
  return( k );
}

ComplexValue cadd( ComplexValue i, ComplexValue j )
{
  ComplexValue k;
  
  k.real = i.real + j.real;
  k.imag = i.imag + j.imag;
  
  return( k );
}

ComplexValue cinv( ComplexValue i )
{
  ComplexValue k;
  
  k.real = -i.real;
  k.imag = -i.imag;
  
  return( k );
}

ComplexValue csub( ComplexValue i, ComplexValue j )
{
  ComplexValue k;
  
  k.real = i.real - j.real;
  k.imag = i.imag - j.imag;
  
  return( k );
}

ComplexValue cmpl( ComplexValue i, ComplexValue j )
{
  ComplexValue k;
  
  k.real = i.real*j.real - i.imag*j.imag;
  k.imag = i.real*j.imag + i.imag*j.real;
  
  return( k );
}

ComplexValue cdiv( ComplexValue i, ComplexValue j )
{
  ComplexValue k;
  double dd;
  
  dd = j.real*j.real + j.imag*j.imag;
  
  k.real = (i.real*j.real + i.imag*j.imag)/dd;
  k.imag = (i.imag*j.real - i.real*j.imag)/dd;
  
  return ( k );
}

ComplexValue cplxsqrt( ComplexValue a )
{
  ComplexValue b;
  double amp,phase;
  
  amp = sqrt( a.real*a.real + a.imag*a.imag );
  phase = atan( a.imag/a.real )/2.0;
  
  b.real = amp * cos( phase );
  b.imag = amp * sin( phase );
  
  return ( b );
}

