#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/****************************
*        DC CUT             *
****************************/
int
main()
{
  register int   i;
  int            length, dim, index[MAX_INDEX];
  Buffer        *data;
  double         ave;
  
  /***** Load System Parameter *****/
  read_syscom();
  data = GetSeries(0, &dim, index);
  if(data == NULL) exit(17);
  
  /***** DC Cut *****/
  length = IndexSize(dim, index);
  
  ave = 0.0;
  for (i = 0; i < length; i++)  {
    ave += data[i];
  }
  ave /= (double) length;
  
  for (i = 0; i < length; i++) {
    data[i] = data[i] - ave;
  }
  
  /***** Store System Parameter *****/
  ReturnSeries(data, dim, index);
  FreeBuffer(data);
  return 0;
}
