/*******************************************
 * Digital Signal Processing Command Lib.  *
 *                   Presented By K.Takebe *
 *******************************************/
/*******************************************
 *  COMMAND NAME : det                     *
 *    ( Ver 1.0 : 1993/03/19 )             *
 *******************************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define FLOAT_MINIMUM 1.0e-15

double determ _ANSI_ARGS_((Buffer *a, int n ));


int
main()
{
  Buffer *x, *y, *xx;
  int    index[MAX_INDEX];
  int    dim, i, l, m, n;

  read_syscom();

  x = GetSeries( 0, &dim, index );
  if ( x == NULL )
    exit(4);

  switch ( dim ) {
  case 1: exit(24); break;
  case 2: if ( index[1] != index[0] )
    exit(7);
    ReturnScalar( determ( x, index[0] ) );
    break;
    
  default:
    if ( index[dim-2] != index[dim-1] )
      exit(7);
    n = index[dim-2];
    m = index[dim-2]*index[dim-1];
    l = IndexSize(dim,index)/m;
    if ((y = AllocBuffer( l )) == NULL )
      exit(8);

    for ( xx = x, i = 0; i < l ; i++, xx += m )
      y[i] = determ( xx, n );
    ReturnSeries( y , dim-2, index );
    FreeBuffer( y );
    break;
  }
  FreeBuffer( x );
  return 0;
}

double determ( Buffer *a, int n ){
  double *ai, *aj, *ak, *al, *pai, *pal;
  double piv, div, w, det = 1.0;

  for ( pai = (ai=a)+n*n-1, pal = a+n-1; ai < pai; ai += n+1, pal += n ) {
/*    printf("1;%1.1lf, %1.1lf, %1.1lf, %1.1lf\n", piv, div, w, det);*/
    for ( piv = *(aj = ak = ai); (aj += n) < pai; )
      if (((( w = *aj) > 0 ? w : -w ) > piv ))
	piv = *(ak = aj);
    if (piv == 0) 
      return (0);
/*    printf("2;%1.1lf, %1.1lf, %1.1lf, %1.1lf\n", piv, div, w, det);*/
    det *= piv*(ak != ai ? -1.0: 1.0);
/*    printf("3;%1.1lf, %1.1lf, %1.1lf, %1.1lf\n", piv, div, w, det);*/
    for ( *ak++ = *ai, *ai = piv, al = ai; al < pal;
	 w = *ak, *ak++ = *(++al), *al = w );
/*    printf("4;%1.1lf, %1.1lf, %1.1lf, %1.1lf\n", piv, div, w, det);*/
    if(piv == 0)
      continue;
    for ( aj = ai; (aj += n) < pai; )
      for ( div = *(ak = aj)/piv, al = ai; al < pal; )
	*(++ak) -= *(++al)*div;
/*    printf("5;%1.1lf, %1.1lf, %1.1lf, %1.1lf\n", piv, div, w, det);*/
  }
  return ( det*(*ai) );
}
