#include <math.h>
/*******************************************************
  Subroutine FFT1					
  
  ar   : Real Data				
  ai   : Imag Data				
  n    : Data Point				
  flag : Exec Mode ( 0:Forward / -1:Inverse )	
  *******************************************************/
#define PAI 	M_PI

int
fft1(double *ar, double *ai, int n, int flag ){
  int	i, j, it, xp, iter, xp2, k, j1, j2, im1, jm1;
  double	sign, w, wr, wi, dr1, dr2, di1, di2, tr, ti, arg;
  
  if( n < 2 ) return -1;
  
  iter = 0;
  i = n;
  for(;;) {
    if( ( i /= 2 ) == 0 ) break;
    iter ++;
  }
  j = 1;
  for( i = 0; i < iter; i ++ ) j *= 2;
  if( n != j ) return -1;
  /***** flag == 0 : FFT    flag == -1 : INVFFT *****/
  if( flag != -1 ) {
    sign =  -1.0;
  }
  else 	{
    sign =  1.0;
  }
  
  xp2 = n;
  for( it = 0; it < iter; it ++ ) {
    xp = xp2;
    xp2 = xp / 2;
    w = PAI / xp2;
    for( k = 0; k < xp2; k ++ ) {
      arg = k * w;
      wr = cos( arg );
      wi = sign * sin( arg );
      i = k - xp;
      for( j = xp; j <= n; j += xp ) {
	j1 = j + i;
	j2 = j1 + xp2;
	dr1 = ar[ j1 ];
	dr2 = ar[ j2 ];
	di1 = ai[ j1 ];
	di2 = ai[ j2 ];
	tr = dr1 - dr2;
	ti = di1 - di2;
	ar[ j1 ]= dr1 + dr2;
	ai[ j1 ]= di1 + di2;
	ar[ j2 ] = tr *wr - ti * wi;
	ai[ j2 ] = ti *wr + tr * wi;
      }
    }
  }
  j1 = n / 2;
  j2 = n -1;
  j = 1;
  for( i = 1; i <= j2; i ++ ) {
    if( i < j ) {
      im1 = i -1;
      jm1 = j -1;
      tr = ar[ jm1 ];
      ti = ai[ jm1 ];
      ar[ jm1 ] = ar[ im1 ];
      ai[ jm1 ] = ai[ im1 ];
      ar[ im1 ] = tr;
      ai[ im1 ] = ti;
    }
    k = j1;
    while( k < j ) {
      j -= k;
      k /= 2;
    }
    j += k;
  }
  if( flag != 0 ) {
    w = n;
    for( i = 0; i < n; i ++ ) {
      ar[ i ] = ar[ i ] / w;
      ai[ i ] = ai[ i ] / w;
    }
  }
  return 0;
}
