#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"


/******************************************************
 *    COMPLEX FFT PROGRAM                             *
 *----------------------------------------------------*
 *    FFTC  [ P , I ] IB1 , IB2 , IB3 , IB4           *
 *            IB1 : REAL ( INPUT )                    *
 *            IB3 : REAL      ( OUTPUT )              *
 *            IB4 : IMAGINARY ( OUTPUT )              *
 *----------------------------------------------------*
 *                 1986 , 6 , 24                      *
 *               C  Version  7/5/89                   *
 *         SATELLITE Version April 19th, 1993         *
 *****************************************************/
  
extern int  fft1 _ANSI_ARGS_((double *ar, double *ai, int n, int flag));

int
main()
{
  Buffer *xr, *xi;
  int    nn, nm;
  int    ifg, i;
  int    n;
  char   *pc;
  int    o1, o2;
  int    dim1, dim2, index1[MAX_INDEX], index2[MAX_INDEX];
  
  read_syscom();

  pc = GetString( 0 );
  xr = GetSeries( 1, &dim1, index1 );
  xi = GetSeries( 2, &dim2, index2 );
  o1 = GetBufferID(3);
  o2 = GetBufferID(4);

  switch (pc[0]) {
  case 'P':
    ifg = 0;
    break;
  case 'I':
    ifg = -1;
    break;
  default:
    printf(">>>> Illigal mode <<<<<<<\n");
    return (-1);
  }
  
  if ( xr == NULL || xi == NULL )
    exit(4);
  nn = index1[0];
  nm = index2[0];
  if ( dim1 != 1 || dim2 != 1 || o1 <= 0 || o2 <= 0 )
    exit(17);
  
  if (nn != nm)
    exit(18);
  
  n = 1;
  for (i = 1; i <= 20; i++) {
    n *= 2;
    if (n == nn)
      break;
  }
  
  if (i >= 20)
    exit(18);

  /***** FFT *****/
  fft1(xr, xi, nn, ifg);
  
  if ( WriteBuffer( o1, dim1, index1, xr ) == -1 ) exit(3);
  if ( WriteBuffer( o2, dim2, index2, xi ) == -1 ) exit(3);
  
  write_syscom();
  return 0;
}
