#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define PI	M_PI

// N dimensional FFT subroutine
// 28. Jul. 2001

static int fft_n( double *, double *, size_t *, size_t, int );

int fft_n( double *dataR, double *dataI, size_t *dataGeom, size_t dataDim, int transFlag )
{
  double tempR, tempI;
  double w_r, w_i, wn_r, wn_i;
  double sign;
  size_t i, j, k, l, m, n;

  size_t dataLen;
  size_t base, offset;
  size_t tempInd1, tempInd2;
  size_t nn1, nn2, totalLen;

  totalLen = 1;
  for( i=0;i<dataDim;i++ )
    totalLen *= dataGeom[i];

  if( transFlag == 0 )
    sign = -1.;
  else
    sign = 1.;

  base = 1;
  for( l=0;l<dataDim;l++ ){
    dataLen = dataGeom[dataDim-1-l];
    
// bits reverse sorting of input data
    j = 0;
    for( i=0;i<(dataLen-1);i++ ){
      if( j > i ){

	nn1 = totalLen/(dataLen*base);
	for( n=0;n<nn1;n++ ){
	  for( m=0;m<base;m++ ){
	    offset = base*dataLen*n + m;

	    tempInd1 = base*j + offset;
	    tempInd2 = base*i + offset;
	    
	    tempR = dataR[tempInd1];
	    dataR[tempInd1] = dataR[tempInd2];
	    dataR[tempInd2] = tempR;
	    tempI = dataI[tempInd1];
	    dataI[tempInd1] = dataI[tempInd2];
	    dataI[tempInd2] = tempI;
	  }
	}

      }
      k = dataLen>>1;
      while( j >= k ){
	j -= k;
	k /= 2;
      }
      j += k;
    }

// butterfly operation
    for( k=2;k<=dataLen;k<<=1 ){
      wn_r = 1.;
      wn_i = 0.;
      w_r = cos( 2.*PI/((double)k) );
      w_i = sign * sin( 2.*PI/((double)k) );
      nn2 = dataLen / k;
      for( j=0;j<(k>>1);j++ ){
	for( i=0;i<nn2;i++ ){

	  nn1 = totalLen / (dataLen * base);
	  for( n=0;n<nn1;n++ ){
	    for( m=0;m<base;m++ ){
	      offset = base*dataLen*n + m;
	      
	      tempInd1 = base*(i*k + j)+offset;
	      tempInd2 = base*(i*k + j + (k>>1))+offset;
	      
	      tempR = dataR[tempInd2]*wn_r - dataI[tempInd2]*wn_i;
	      tempI = dataR[tempInd2]*wn_i + dataI[tempInd2]*wn_r;
	      dataR[tempInd2] = dataR[tempInd1] - tempR;
	      dataI[tempInd2] = dataI[tempInd1] - tempI;
	      dataR[tempInd1] += tempR;
	      dataI[tempInd1] += tempI;
	    }
	  }

	}
	tempR = wn_r*w_r - wn_i*w_i;
	tempI = wn_r*w_i + wn_i*w_r;
	wn_r = tempR;
	wn_i = tempI;
      }
    }

    base *= dataLen;
  }

  return 0;
}

int
main()
{
  register int    i;
  int             dimr, dimi, indexr[MAX_INDEX], indexi[MAX_INDEX];
  Buffer         *real, *imag, *data;
  int             real_id, imag_id, siz, isign;
  char           *ialp;
  int      nn[MAX_INDEX];
  
  read_syscom();
  
  ialp    = GetString(0);
  real    = GetSeries(1, &dimr, indexr);
  imag    = GetSeries(2, &dimi, indexi);
  real_id = GetBufferID(3);
  imag_id = GetBufferID(4);
  
  if (real == NULL || imag == NULL)
    exit(4);
  if (dimr != dimi)
    exit(16);
  if (!EqualIndex(indexr, indexi, dimr))
    exit(18);
  
  if ( real_id == 0 || imag_id == 0 )
    exit(3);

  for( i=0;i<MAX_INDEX;i++ )
    nn[i] = 0;
  CopyIndex(nn, indexr, dimr);
  siz = IndexSize(dimr, indexr);
  
  data = AllocBuffer(2 * siz + 1);

  isign = 0;
  if ( ialp[0] == 'I' || ialp[0] == 'i' )
    isign = 1;
  
  /* two-dimensional array (inverse transform) */

  if( isign != 0 )
    printf("%d  %d  %d   %d\n", dimr, nn[0], nn[1], -1 );
  else
    printf("%d  %d  %d   %d\n", dimr, nn[0], nn[1], 1 );
  fft_n( real, imag, nn, dimr, isign );
  
  /* inverse transform */
  if (isign != 0) {
    for (i = 0; i < siz; i++) {
      real[i] = real[i] / siz;
      imag[i] = imag[i] / siz;
    }
  }
  /* two-dimensional array (Fourier transform) */
  
  if (WriteBuffer(real_id, dimr, indexr, real) == -1 ||
      WriteBuffer(imag_id, dimi, indexi, imag) == -1 ) {
    printf("cannot write buffer\n");
    exit(3);
  }

  write_syscom();
  return 0;
}
