#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

/********************************************************

ƣɣҥե륿ˤ
LOWPASSե륿
BANDPASSե륿
HIGHPASSե륿
߷ס


********************************************************/

#define TEMPMAX 4096
#define PAI 	M_PI


/* in fft_sub.c */
extern int     fft1    _ANSI_ARGS_((Buffer *ar, Buffer *ai, int n, int flag ));


static void    firmake _ANSI_ARGS_((Buffer *xr, Buffer *xi, int n,
				    Buffer *coef, int dpt, int wn,
				    Buffer aa ));

static void    window  _ANSI_ARGS_((double *coef, int w, int o , double aa ));
static double  kai     _ANSI_ARGS_((int m));
static double  izero   _ANSI_ARGS_((double x));


int
main()
{
  int	 i , n2 , nn , span, fclp , fchp, wn;
  int	 k = 1, dim, idx[MAX_INDEX];
  Buffer aa, fs, fcl , fch , *xr, *xi, *work, *coef;
  
  read_syscom();
  fs = get_sampling();

  k    = (int)GetScalar(0); /* Filter Mode */
  span = (int)GetScalar(1); /* Filter Span */

  if ( ( work = GetSeries(2,&dim,idx) ) == NULL ) {
    work = AllocBuffer( 1 );
    work[0] = GetScalar(2);
    dim = 1;
    idx[0] = 1;
  }
  wn = (int)GetScalar(3); /* Window Type */

  aa = 0.0;
  if ( wn == 4 ) {
    aa = (int)GetScalar(4); /* Kaiser */
    if ( aa <= 21.0 ) {
      printf("bad parameter No.5\n");
      exit(2);
    }
  }

  if ( ( k == 3 && idx[0] < 2 ) || idx[0] < 0 ) {
    printf("illegal parameter : cutoff frequency.\n");
    exit(2);
  }

  nn = TEMPMAX;
  n2 = nn / 2;

  xr   = AllocBuffer( nn );
  xi   = AllocBuffer( nn );
  coef = AllocBuffer( span );
  if ( xr == NULL || xi == NULL || coef == NULL )
    exit(8);

  for ( i = 0; i < nn; i++ )
    xi[i] = 0.0;

  switch( k ){
  case 1 :
    printf( "\n******  Low Pass Filter  ******\n" );
    fcl = 2.0*work[0]/fs;
    fclp = (int) (n2 * fcl);
    for( i = 0; i < nn; i ++ )
      xr[ i ] = 1.0;
    for( i = fclp; i < n2; i ++ )
      xr[ i+1 ] = xr[ nn-1-i ] = 0.0;
    
    break;
  case 2 :
    printf( "\n******  High Pass Filter  ******\n" );
    fch = 2.0*work[0]/fs;
    fchp = (int) (n2 * fch);
    for( i = 0; i < nn; i ++ )
      xr[ i ] = 0.0;
    for( i = fchp; i < n2; i ++ )
      xr[ i+1 ] = xr[ nn-1-i ] = 1.0;
    
    break;
  case 3 :
    printf( "\n******  Band Pass Filter  ******\n" );
    fcl = 2.0*work[0]/fs;
    fch = 2.0*work[1]/fs;
    fclp = (int) (n2 * fcl);
    fchp = (int) (n2 * fch);
    for( i = 0; i < nn; i ++ )
      xr[ i ] = 0.0;
    for( i = fclp; i < fchp; i ++ )
      xr[ i+1 ] = xr[ nn-1-i ] = 1.0;
    break;
  }

  firmake( xr, xi, nn, coef, span, wn, aa );

  dim = 1;
  idx[0] = span;
  ReturnSeries( coef, dim, idx );
  return 0;
}

static void firmake(Buffer *xr, Buffer *xi, int n, Buffer *coef,
		    int dpt, int wn, Buffer aa ){
  int   i, oh;
  int   nr, ni;

  if( dpt % 2 == 0 ) {
    printf( ">>>> Span is even numeric<<<<\n" );
    exit(2);
  }
  if ( wn < 0 && wn > 4 ) {
    printf( ">>> Window number is out of range <<<\n" );
    exit(2);
  }
  
  nr = ni = n;
  
  n = 1;
  for( i = 1; i <= 16; i ++ ) {
    n *= 2;
    if( n == nr )
      break;
  }
  if ( i == 16 )
    exit(15);

  fft1( xr, xi, nr, -1 );
  
  oh = ( dpt - 1 ) / 2;
  for( i = 0; i <= oh; i ++ ) 
    coef[ oh + i ] = coef[ oh - i ] = xr[ i ];
  
  window( coef, wn , dpt , aa );
}


/*******************************************************
  Subroutine WINDOW			
  coef	:					
  w	: window number				
  o	: order
  aa      : parameter aa determines the shape of the Kaiser window
  *******************************************************/
static void window( double *coef, int w, int o , double aa ){
  int       i, oh, o1;
  Buffer   *win;
  double    v1;
  double    dt;
  double    alp;
  
  dt = 1.0/get_sampling();

  o1 = o - 1;
  oh = ( o-1 ) / 2;

  if (( win = AllocBuffer( o ) ) == NULL )
    exit(8);

  switch( w ) {
    
    /*************      Do Nothing      *************/
  default: for( i = 0; i <= o1; i ++ )
    win[ i ] = 1;
    break;
    
    /*************      Hanning      ****************/
  case 1 : for( i = 0; i <= o1; i ++ )
    win[ i ] = 1 - cos( 2 * PAI * i / o1 );
    break;
    
    /************       Hamming     *****************/
  case 2 : for( i = 0; i <= o1; i ++ )
    win[ i ] = 0.54 - 0.46 * cos( 2 * PAI * i / o1 );
    break;
    
    /************       Blackmann   ****************/
  case 3 : for( i = 0; i <= o1; i ++ )
    win[ i ] = 0.42 - 0.5 * cos( 2 * PAI * i / o1 )                                      + 0.08 * cos( 4 * PAI * i / o1 );
    break;
    
    /************       Kaiser      ****************/
  case 4 : 
    if(aa > 50.0) alp = 0.1102*(aa-8.7);
    else          alp = 0.5842*pow(aa-21.0,0.4)+0.07886*(aa-21.0);

    for( i = 0; i<= oh; i++){
	v1 = alp*sqrt(1.0 - pow((double)(o-1-2*i)/(double)(o-1),2.0));
	v1 = alp*sqrt(1.0 - pow((double)(o1-2*i)/(double)o1 ,2.0));
    	win[i] = win[o-1-i] = izero(v1)/izero(alp);
    }
    break;
  }

  for( i = 0; i <= o1; i ++ ) coef[i] *= win[i];

  FreeBuffer( win );
}

static double izero(double x){
  int i;

  double v1,v2;
  v2=0.0;
  for(i = 1; i <= 15; i++){
    v1  = pow(x/2.0,(double)i)/kai(i);
    v2 += pow(v1,2.0);
  }
  return (1.0+v2);
}

static double kai(int m){
  int i;
  double v;
  v = 1.0;
  for(i=1; i <= m; i++ ){
    v *= i;
  }
  return v;
}

