#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/********************************************
 *    HILBERT TRANSFORM PROGRAM             *
 *------------------------------------------*
 *    HIL IB1 , IB2 , IB3                   *
 *        IB1 : REAL      ( INPUT  )        *
 *        IB2 : REAL      ( OUTPUT )        *
 *        IB3 : IMAGINARY ( OUTPUT )        *
 *------------------------------------------*
 *                    1986 , 11 , 6         *
 *                    1989 ,  7 , 28        *
 *******************************************/

extern int  fft1  _ANSI_ARGS_((double *ar, double *ai, int n, int flag ));

int
main()
{
  Buffer *xr, *xi, *xxr, *xxi, *max;
  int    o1, o2, dim, idx[MAX_INDEX];
  int    i, n, n1, nn, nn1;
  
  read_syscom();

  xr = GetSeries( 0, &dim, idx );
  n1 = IndexSize( dim, idx );
  n = 1;
  for ( i = 0; i < 12; i ++ ) {
    n *= 2;
    if ( n == n1 ) break;
  }
  if ( n != n1 )
    exit( 18 );
  if (( xi = AllocBuffer( n1 ) ) == NULL )
    exit(4);
  o1 = GetBufferID(1);
  o2 = GetBufferID(2);
  if ( o1 <= 0 || o2 <= 0 )
    exit(3);

  nn = n1;
  max = xi + nn;
  for ( xxi = xi; xxi < max; xxi++ )
    (*xxi) = 0.0;
  
  /***** FFT *****/
  fft1( xr, xi, nn, 0 );
  
  nn1 = nn/2;
  for ( xxr = xr+nn1, xxi = xi+nn1; xxr < max; xxr++, xxi++ ) {
    (*xxr) = 0.0;
    (*xxi) = 0.0;
  }
  max = xi+nn1;
  for ( xxr = xr, xxi = xi; xxi < max; xxr++, xxi++ ) {
    (*xxr) *= 2.0;
    (*xxi) *= 2.0;
  }
  
  /***** Inv FFT *****/
  fft1( xr, xi, nn, -1 );
  
  if ( WriteBuffer( o1, dim, idx, xr ) == -1 ) exit(3);
  if ( WriteBuffer( o2, dim, idx, xi ) == -1 ) exit(3);
  
  FreeBuffer( xr );
  FreeBuffer( xi );

  write_syscom();
  return 0;
}
