#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
  
  /*****************************************************
   *      Complex Cepstrum Program                      *
   *        For Complex Cepstrum                        *
   *----------------------------------------------------*
   *      ICEP buf1,buf2,buf3,buf4                      *
   *           buf1 -- input buffer( real )             *
   *           buf2 -- input buffer( imag )             *
   *           buf3 -- output buffer( real )            *
   *           buf4 -- output buffer( imag )            *
   *----------------------------------------------------*
   *         1986 , 7 , 17   1989 , 7 , 28  T.Kobayashi *
   ******************************************************/
extern int  fft1  _ANSI_ARGS_((double *ar, double *ai, int n, int flag ));

int
main()
{
  Buffer *workr, *worki, *wr, *wi, *max;
  int    i, iofd1, iofd2, nod, n2;
  int    dim, dim2, index[MAX_INDEX], index2[MAX_INDEX];
  Buffer phs0, phs1, amp, phase ;
  
  /***** Load System Parameter *****/
  read_syscom() ;

  /***** Initial Set *****/
  
  workr = GetSeries(0, &dim, index );
  worki = GetSeries(1, &dim2, index2 );
  iofd1 = GetBufferID(2);
  iofd2 = GetBufferID(3);

  if ( workr == NULL )
    exit(4);
  if ( iofd1 <= 0 || iofd2 <= 0 )
    exit(3);

  /***** Buffer -> Work Area *****/

  nod = IndexSize( dim, index );
  if ( worki == NULL ) {
    if (( worki = AllocBuffer( nod ) ) == NULL )
      exit(8);
    max = worki+nod;
    for ( wi = worki; wi < max; wi++ )
      (*wi) = 0.0;
  } else
    if ( IndexSize( dim2, index2 ) != nod )
      exit(18);
  
  /***** FFT *****/
  fft1( workr, worki, nod, 0 );
  
  /***** Restore Liner Component & Complex Exponential *****/
  
  n2 = nod/2;
  phs0 = worki[0];
  phs1 = worki[n2];

  for ( wr = workr, wi = worki, i = 0; i < nod; wr++, wi++, i++ ) {
    amp = (*wr);
    phase = (*wi);
    phase += ( (double)i * ( phs1-phs0 )/(double)n2 + phs0 ) ;
    (*wr) = exp( amp ) * cos( phase ) ;
    (*wi) = exp( amp ) * sin( phase ) ;
  }
  
  /***** IFFT *****/
  fft1( workr, worki, nod, -1 ) ;
  
  /***** Work Area -> Buffer *****/

  if ( WriteBuffer( iofd1, dim, index, workr ) <= 0 )
    exit(3);
  if ( WriteBuffer( iofd2, dim, index, worki ) <= 0 )
    exit(3);

  write_syscom() ;
  return 0;
}
