#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/**********************************************************
 *   Infinite Inpulse Response Fileter                     *
 *           FILTERING SPAN = 25                           *
 *---------------------------------------------------------*
 *       X = IIR( BUF1,BUF2 )                              *
 *            BUF1 : PARAMETER BUFFER                      *
 *            BUF2 : INPUT BUFFER                          *
 *---------------------------------------------------------*
 *                        1986 , 7 , 16                    *
 *       F to C       at  1988 , 8 ,  3 by M.Akima         *
 *   SATELLITE LANGUAGE VERSION                            *
 *       At 29th Dec 1992 modified by S.Hitomi             *
 **********************************************************/

static int  iir1 _ANSI_ARGS_((Buffer *filter, int span,
			      Buffer *work, int dpt));

int
main()
{
  Buffer         *work, *p_work;
  int             dimp, indexp[MAX_INDEX];
  int             dimx, indexx[MAX_INDEX];
  
  read_syscom();
  
  /* Get Arguments from SATELLITE LANGUAGE */
  p_work = (Buffer *)GetSeries(0, &dimp, indexp);
  work   = (Buffer *)GetSeries(1, &dimx, indexx);
  
  if (p_work == NULL || work == NULL) exit(4);
  if ( dimp != dimx ) exit(16);

  /* LOAD COEF. FROM BUFFER AND EXECUTE FIR     */
  if ( dimp == 1 ) {
    if (iir1(p_work, indexp[0], work, indexx[0]) == -1)
      exit(2);
    ReturnSeries(work, dimx, indexx);
  /*
  } else if ( dimp == 2 ) {
    if (iir2(p_work, indexp, work, indexx ) == -1)
      exit(2);
    ReturnSeries(work, dimx, indexx);
  */
  } else
    exit(24);

  write_syscom();
  return 0;
}

/* GENETATE DATA WITH SET VALUE     */

static int iir1(Buffer *filter, int span, Buffer *work, int dpt){
  register int     i, j, k;
  Buffer           sum, v;
  
  for (i = 1; i <= dpt; i++) {
    sum = 0.0;
    for (j = 1; j <= span; j++) {
      k = i - j;
      if (k < 1) break;
      v = 0.0;
      if ( fabs(work[k-1]) > 1.0e-30 )
	v = ( fabs( work[k-1]) > 1.0e15 ) ? 1.0e15 : work[k-1];
      sum += (filter[j-1] * v);
    }
    work[i-1] += sum;
  }
  return 0;
}

