#include <stdio.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "Complex.h"

static void  get_transfar_function _ANSI_ARGS_((int mm, ComplexValue *work,
						Buffer *a));
static void  get_func              _ANSI_ARGS_((ComplexValue *a, int m,
						ComplexValue *root ));
static void  equmpl                _ANSI_ARGS_((ComplexValue *a,
						ComplexValue *b, int *m,
						ComplexValue root ));

int
main()
{
  int dimpr, indexpr[MAX_INDEX], dimpi, indexpi[MAX_INDEX];
  int dimzr, indexzr[MAX_INDEX], dimzi, indexzi[MAX_INDEX];
  int mm, n, l, i, a_id, b_id;

  Buffer *pr, *pi, *zr, *zi, *a, *b;
  ComplexValue *work;

  /* get parameter */
  read_syscom();
  zr   = GetSeries(0,&dimzr,indexzr);
  zi   = GetSeries(1,&dimzi,indexzi);
  pr   = GetSeries(2,&dimpr,indexpr);
  pi   = GetSeries(3,&dimpi,indexpi);
  a_id = GetBufferID(4);
  b_id = GetBufferID(5);

  /* parameter check */
  if ( pr == NULL || pi == NULL || zr == NULL || zi == NULL )
    exit(4);
  if ( indexpr[0] != indexpi[0] || indexzr[0] != indexzi[0] )
    exit(18);
  if ( a_id == 0 || b_id == 0 )
    exit(17);

  mm = IndexSize( dimpr, indexpr );
  n = mm+1;
  l = 2*n-1;
  /* memory allocation */
  a = AllocBuffer(n);
  b = AllocBuffer(l);
  work = (ComplexValue*)malloc(sizeof(ComplexValue)*n);
  if ( a == NULL || b == NULL || work == NULL )
    exit(8);

  /* calculate "a" from pole location */
  for ( i = 0; i < mm; i++ )
    work[i] = cplx( pr[i], pi[i] );
  work[mm] = cplx( 0.0, 0.0 );
  get_transfar_function( mm, work, a );

  /* calculate "b" from pole location */
  for ( i = 0; i < mm; i++ )
    work[i] = cplx( zr[i], zi[i] );
  work[mm] = cplx( 0.0, 0.0 );
  get_transfar_function( mm, work, b );

  /* change coeficient to suitable one */
  for ( i = 0; i < n; i++ )
    a[i] = -a[i+1];
  for ( i = n; i < l; i++ )
    b[i] = 0.0;
  
  dimpr = 1;
  indexpr[0] = mm;
  indexzr[0] = l;
  if ( WriteBuffer( a_id, dimpr, indexpr, a ) == -1 ) exit(3);
  if ( WriteBuffer( b_id, dimpr, indexzr, b ) == -1 ) exit(3);

  FreeBuffer( pr );
  FreeBuffer( pi );
  FreeBuffer( zr );
  FreeBuffer( zi );
  FreeBuffer( a );
  FreeBuffer( b );
  free( work );
  write_syscom();
  return 0;
}

static void get_transfar_function( int mm, ComplexValue *work, Buffer *a ){
  int i;
  ComplexValue *s;

  void get_func();

  s = (ComplexValue*)malloc(sizeof(ComplexValue)*(mm+1));

  for ( i = 0; i <= mm ; i++ )
    s[i] = cplx( 0.0, 0.0 );

  get_func( s, mm, work );
  for ( i = 0; i <= mm; i++ )
    a[i] = s[i].real;
  free( s );
}

static void get_func( ComplexValue *a, int m, ComplexValue *root ){
  int i, n;
  ComplexValue *b;

  b = (ComplexValue*)malloc(sizeof(ComplexValue)*(m+1));

  n = 0;
  a[0] = cplx( 1.0, 0.0 );

  for ( i = 0; i < m; i++ )
    equmpl( a, b, &n, root[i] );

  free( b );
}

static void equmpl( ComplexValue *a, ComplexValue *b, int *m,
		    ComplexValue root ){
  ComplexValue c, d;
  int i;

  c = cplx(0.0,0.0);
  d = root;

  for ( i = 0; i <= *m; i++ )
    b[i] = a[i];

  for ( i = 1; i <= *m; i++ )
    a[i] = csub( b[i],  cmpl( d, b[i-1] ) );
  c = cmpl( d , b[*m] );
  (*m)++;
  a[*m] = cinv(c);
}

