#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*****************************************************
*    Integration                                     *
*****************************************************/
int
main()
{
  register int    i;
  Buffer         *data = NULL, *need_integ = NULL, *integ = NULL, sum;
  int             dim1, index1[MAX_INDEX];
  int             dim2, index2[MAX_INDEX];
  int             n, id;

  /***** Load System Parameter *****/
  read_syscom();

  /* Get Arguments from SATELLITE LANGUAGE */
  data       = GetSeries(0, &dim1, index1);
  need_integ = GetSeries(1, &dim2, index2);
  id         = GetBufferID(1);

  if (data == NULL)
    exit(4);
  n = IndexSize(dim1, index1);

  if (need_integ != NULL) {
    FreeBuffer(need_integ);
    if ((integ = (Buffer *) CAllocBuffer(n)) == NULL) exit(8);
  }
  /***** Calculation ( Integ ) *****/
  sum = 0.0;
  if (need_integ != NULL) {
    for (i = 0; i < n; i++) {
      sum += data[i];
      integ[i] = sum;
    }
    if ( WriteBuffer(id, dim1, index1, integ) <= 0 ) exit(3);
  } else {
    for (i = 0; i < n; i++)
      sum += data[i];
  }

  ReturnScalar(sum);
  write_syscom();
  return 0;
}
