/*******************************
* Visual Process Command Lib.  *
*       ( 2-D Version )        *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : inv            *
*    ( Ver 1.0 : 1993/03/17 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

static int   inv _ANSI_ARGS_((Buffer *x, Buffer *y, int n));

int
main()
{
  Buffer *x, *y, *xx, *yy, *xmax;
  int    idx[MAX_INDEX];
  int    dim, a, n, l;

  read_syscom();
  x = GetSeries( 0, &dim, idx );
  if ( x == NULL )
    exit(4);

  switch ( dim ) {

  case 1:
    printf("cannot calculate Series value\n");
    exit(24);
    break;

  default:
    if ( idx[dim-2] != idx[dim-1] ) 
      exit(7);

    l  = IndexSize( dim, idx );
    n  = idx[dim-1];
    a  = n*n;
    xmax = x + l;
    if (( y = AllocBuffer( l ) ) == NULL )
      exit(8);

    for ( xx = x, yy = y; xx < xmax; xx += a, yy += a ) 
      if ( inv( xx, yy, n ) != 1 )
	printf("cannot calculate inverse matrix\n"); 
    ReturnSeries( y, dim, idx );
    FreeBuffer( y );
  }
  FreeBuffer( x );
  return 0;
}

static int  inv( Buffer *x, Buffer *y, int n ){
  int    dpt1, dpt2, i, j, k;
  double tmp1;

  for ( i = 0; i < n; i++ ) {
    dpt1 = i*n;
    for ( j = 0; j < n; j++ )
      y[ dpt1+j ] = 0.0;
    y[ dpt1+i ] = 1.0;
  }
  for ( i = 0; i < n; i++ ) {
    dpt2 = i*n;
    for ( j = i+1; j < n; j++ ) {
      dpt1 = j*n;
      if ( fabs(x[dpt1+i]) > fabs(x[dpt2+i]) ) {
	for ( k = 0; k < n; k++ ) {
	  tmp1      = x[dpt1+k];
	  x[dpt1+k] = x[dpt2+k];
	  x[dpt2+k] = tmp1;
	  tmp1      = y[dpt1+k];
	  y[dpt1+k] = y[dpt2+k];
	  y[dpt2+k] = tmp1;
	}
      }
    }
    if ( fabs( x[dpt2+i] ) > DBL_EPSILON ) {
      for ( j = i+1; j < n; j++ )
	x[dpt2+j] /= x[dpt2+i];
      for ( j = 0; j < n; j++ )
	y[dpt2+j] /= x[dpt2+i];
      for ( j = 0; j < n; j++ )
	if ( i != j ) {
	  dpt1 = j*n;
	  for ( k = i+1; k < n; k++ )
	    x[dpt1+k] -= x[dpt2+k] * x[dpt1+i];
	  for ( k = 0; k < n; k++ )
	    y[dpt1+k] -= y[dpt2+k] * x[dpt1+i];
	}
    } else
      return(-1);
  }
  return(1);
}
