#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
/*****************************************************************
(LOW-PASS)
Хɣɣҥѥե륿߷
ʼη׻ϤʤϤ롥

	b5 = LPBTW fc,n,b1,b2,b3,b4,b5
		fc......åȥռȿȿˡ
		n.......ե륿
		b1......¿
		b2......
		b3......˼¿
		b4......˵
						'92/3/25
						ľ
						'92/6/21
						TODA @MCT
*****************************************************************/
#define PAI 	3.141592654
#define MAXORD	101

static void  btwlp _ANSI_ARGS_((int  n, double fc,
				double *are, double *aim,
				int *oinc, double *gain ));

int
main()
{
  double   fc,fs, gain ;
  int	   i, j, n, oinc;
  double   are[MAXORD],aim[MAXORD];
  double   work[MAXORD];
  
  int      dim;
  int      b1,b2,b3,b4;
  /*((((((((((((((((((((((ǡɤ߹ߡ)))))))))))))))))))))))*/
  
  read_syscom(); 
  fs = get_sampling();
  
  fc = GetScalar(0);       
  n  = (int)GetScalar(1);
  b1 = GetBufferID(2);
  b2 = GetBufferID(3);
  b3 = GetBufferID(4);
  b4 = GetBufferID(5);

  
  if ( b1 == 0 || b2 == 0 || b3 == 0 || b4 == 0 ) exit(3);
  if ( n > MAXORD ){ fprintf(stderr,"Filter Order is Too Large!\n"); exit(2);}
  if (fc<=0){ fprintf(stderr, "Illegal Cut-off Frequency\n"); exit(2); }
  if (n<=0) exit(2);
  
  
  /*(((((((((((((((((((((((    η׻))))))))))))))))))))))))*/
  
  fc=2.0*fc/fs;        
  
  btwlp( n, fc, are, aim, &oinc, &gain );
  
  /*......for debugging
    printf("oinc %d\n", oinc);
    for( i=0 ; i<n ; i++){
    printf("are %e\n", are[i]);
    }
    */
  /*(((((((((((((((((((((((    񤭹    ))))))))))))))))))))))))))))*/
  /*...................			*/
  for ( i = 0 ; i < n ; i++ ){
    work[i] = -1.0 ;
  }
  
  dim=1;
  WriteBuffer(b1,dim,&n,work);

  for ( i = 0 ; i < n ; i++ ) work[i] = 0.0 ;
  WriteBuffer(b2,dim,&n,work);

  /*...................				*/
  if ( oinc == n/2 )
    for ( i = n/2, j = 0; i < n; i++, j++ ) {
      are[i] =  are[j];
      aim[i] = -aim[j];
    }
  else
    for ( i = n/2+1, j = 1; i < n; i++, j++ ) {
      are[i] =  are[j];
      aim[i] = -aim[j];
    }
  WriteBuffer(b3,dim,&n,are);
  WriteBuffer(b4,dim,&n,aim);

  /*...................gain			*/
  ReturnScalar(gain);
  
  write_syscom();
  return 0;
}


/*********************************************************************
  
  ˤΰַ׻
  
  :
  n.............ե륿
  fc............åȥռȿ
  ϡ
  are...........ˤμ¿ɸ
  aim...........ˤεɸ
  oinc..........ɽˤο
  gain..........ե륿
  **********************************************************************/
static void  btwlp(int  n, double fc, double *are, double *aim,
		   int *oinc, double *gain ){
  double	a, tsa, tsb, tsg, tzb, tzc;
  int	i, cas, im;
  /*
    ................Ϣ³ȿؤѴʥץס
    */
  fc = 4.0*tan(0.5*PAI*fc);
  /*		printf("fc=%f\n",fc);*/
  /*
    .................ãؿη׻
    */
  cas = n%2;
  cas++;
  switch(cas){
    /*
      ...................
      */
  case 1:
    /*						*/
    *oinc = 0 ;
    *gain = 1.0 ;
    for( i=1 ; i<=(n-1) ; i+=2 ){
      a = 2.0*sin((double)(i)*PAI/(2.0*(double)(n)));
      tsa = a*fc;
      tsb = fc*fc;
      tsg = 1.0/(16.0+4.0*tsa+tsb);
      tzb = 2.0*tsg*(tsb-16.0);
      tzc = tsg*(16.0-tsa*4.0+tsb);
      /*						    */
      *gain = tsg*tsb*(*gain);
      /*						    */
      if( tzb*tzb-4.0*tzc < 0.0 ) im = 1;
      else 	    im = 2;
      switch (im ){
	/*
	  ....................
	  */
      case 1:
	are[*oinc] = -tzb/2.0;
	aim[*oinc] = sqrt(4.0*tzc-tzb*tzb)
	  /2.0;
	*oinc += 1;
	break;
	/*
	  ....................º
	  */
      case 2:
	are[*oinc] = (-tzb 
		      +sqrt(tzb*tzb-4.0*tzc))
	  /2.0;
	are[*oinc+1] = (-tzb
			-sqrt(tzb*tzb-4.0*tzc))
	  /2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
    }
    break;
    /*
      .....................
      */
  case 2:
    /*						*/
    *oinc = 0;
    *gain = 1;
    /*..................*/
    tsa = fc;
    *gain *= tsa;
    *gain = *gain/(tsa+4.0);
    are[*oinc] = -(tsa-4.0)/(tsa+4.0);
    aim[*oinc] = 0.0;
    (*oinc)++;/*..................N*/
    for( i=1 ; i<=(n-2) ; i+=2 ){
      a = 2.0*sin((double)(i)*PAI/(2.0*(double)(n)));
      tsa = a*fc;
      tsb = fc*fc;
      tsg = 1.0/(16.0+4.0*tsa+tsb);
      tzb = 2.0*tsg*(tsb-16.0);
      tzc = tsg*(16.0-tsa*4.0+tsb);
      /*						    */
      *gain = tsg*tsb*(*gain);
      /*						    */
      if( tzb*tzb-4.0*tzc < 0.0 ) im = 1;
      else 	    im = 2;
      switch (im ){
	/*
	  ....................
	  */
      case 1:
	are[*oinc] = -tzb/2.0;
	aim[*oinc] = sqrt(4.0*tzc-tzb*tzb)
	  /2.0;
	*oinc += 1;
	break;
	/*
	  ....................º
	  */
      case 2:
	are[*oinc] = (-tzb 
		      +sqrt(tzb*tzb-4.0*tzc))
	  /2.0;
	are[*oinc+1] = (-tzb
			-sqrt(tzb*tzb-4.0*tzc))
	  /2.0;
	aim[*oinc] = 0.0;
	aim[*oinc+1] = 0.0;
	*oinc += 2;
	break;
      }
    }
    break;
  }
}
