#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "rand_sub.h" /* by okumura */

/******************************************
      mrand(dpt,init,mean,var);
  
	dpt   : Output data points
	init  : seed
        mean  : mean vector
	var   : covariance matrix

        Date 1st Mar. 1995 by T.Hayasaka
******************************************/
static void    choles       _ANSI_ARGS_((Buffer *x, Buffer *y, int dpt_n));
  
int
main()
{
  register int    i, j, k;
  int      dpt, init, n;
  Buffer   *mean, *variance;
  Buffer   *work, *work2, *covariance;
  int 	   dim_m, dim_v;
  int	   index_m[MAX_INDEX], index_v[MAX_INDEX], index[MAX_INDEX];
  int      M[521], J;

  read_syscom();

  dpt  = (int)GetScalar(0);
  init = (int)GetScalar(1);

  if((mean = GetSeries(2,&dim_m,index_m)) == NULL) 
    exit(4);
  if((variance = GetSeries(3,&dim_v,index_v)) == NULL)
    exit(4);
  
  if(init == 0)
    exit(2);
  if((dim_m != 1) || (dim_v !=2 ))
    exit(7);
  n = index_m[0];
  if((n != index_v[0]) || (n != index_v[1]))
    exit(7);
  if (( work = AllocBuffer(dpt * n) ) == NULL )
    exit(8);

  work2 = AllocBuffer(dpt * n);
  covariance = AllocBuffer(n * n);

  Gen_M_series(init, M);
  J = 0;

  index[0] = dpt;
  index[1] = n;
  
#ifdef DEBUG
  for (i = 0; i < 521; i++)
    printf("M series :%5d \n", M[i]);
#endif
  
  for (i = 0; i < dpt * n; i++)
    work[i] = rnd_nor(i, 0.0, 1.0, M, &J);

  choles(variance, covariance, n);

  for (i = 0; i < dpt; i++){
    for (j = 0; j < n; j++){
      work2[i*n+j] = mean[j];
      for (k = 0; k <= j; k++){
	work2[i*n+j] = work2[i*n+j] + work[i*n+k] * covariance[j*n+k];
      }
    }
  }
  
  ReturnSeries(work2, 2, index);

  FreeBuffer( work );
  FreeBuffer( work2 );
  FreeBuffer( mean );
  FreeBuffer( variance );
  FreeBuffer( covariance );

  write_syscom();
  return 0;
}

/*
 * Cholesky Decomposition
 */

static void choles(Buffer *x, Buffer *y, int dpt_n){	
  Buffer	sum1, sum2;
  int	i, j, k;

  for( i = 0; i < dpt_n; i++ ){
    for( j = 0; j < dpt_n; j++ ){
      y[i*dpt_n+j] = 0.0;
    }
  }

  for( j = 0; j < dpt_n; j++ ){
    sum1 = x[j*dpt_n+j];
    
    for( k = 0; k <= j-1; k++ ){
      sum1 = sum1 - y[j*dpt_n+k] * y[j*dpt_n+k];
    }

    if( sum1 >= 0.0 ) y[j*dpt_n+j] = sqrt(sum1);

    for( i = j+1; i < dpt_n; i++){
      sum2 = 0.0;

      for( k = 0; k <= j-1; k++ ){
	sum2 = sum2 + y[i*dpt_n+k] * y[j*dpt_n+k];
      }

      y[i*dpt_n+j] = (x[i*dpt_n+j] - sum2) / y[j*dpt_n+j];
    }
  }
}

