#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
  
  /*****************************************************
   *      THE FUNCTION SOLVING NORMAL EQUATION 
   *
   *      NMEQ  X,Y
   *            X : DESIGN MATRIX
   *            Y : OUTPUT VECTOR
   ******************************************************
   *          Dec 13, 1994 by Dora(T.Hayasaka) 
   *****************************************************/
  
static void hushld  _ANSI_ARGS_((double x[], double y[],
				 int dpt_n, int dpt_k));

int
main()
{
  int   dim1, index1[MAX_INDEX], dim2, index2[MAX_INDEX];
  int   i, j, ip, dpt;
  Buffer *hx, *zy;
  Buffer *xx, *yy;
  Buffer *a;

  read_syscom() ;

  if (( xx = GetSeries(0, &dim1, index1 ) ) == NULL )
    exit(4);
  if (( yy = GetSeries(1, &dim2, index2 ) ) == NULL )
    exit(4);

  if ( dim1 != 2 )
    exit(24);
  if ( dim2 > 2 )
    exit(24);

  dpt = index1[0];
  ip = index1[1];

/* modified by dora 1995.11.8 */

  a = AllocBuffer( ip );

  zy = AllocBuffer( dpt * (ip+1) );
  hx = AllocBuffer( dpt * (ip+1) );

  for(i=0;i<dpt;i++){
      for(j=0;j<ip;j++){
          zy[i*(ip+1)+j] = xx[i*ip+j];
      }
      zy[i*(ip+1)+ip] = yy[i];
  }
  
  hushld(zy,hx,dpt,ip+1);

  a[ip-1] = hx[(ip-1)*(ip+1)+ip] / hx[(ip-1)*(ip+1)+ip-1];
  for(i=ip-2;i>=0;i--){
      a[i] = hx[i*(ip+1)+ip];
      for(j=i+1;j<ip;j++){
	  a[i] = a[i] - a[j]*hx[i*(ip+1)+j];
      }
      a[i] = a[i] / hx[i*(ip+1)+i];
  }

  ReturnSeries(a,1,&ip);

  FreeBuffer( hx );
  FreeBuffer( zy );
  FreeBuffer( xx );
  FreeBuffer( yy );
  FreeBuffer( a );
  
  write_syscom();
  return 0;
}


static void hushld(double x[], double y[], int dpt_n, int dpt_k){
  int ii,i,j;
  double h,g,f,s;
  Buffer *d;

  d = AllocBuffer(dpt_n);
  for(i = 0; i < dpt_n; i++){
    for(j = 0; j < dpt_k; j++){
      y[i*dpt_k+j] = x[i*dpt_k+j];
    }
  }

  for(ii = 0; ii < dpt_k; ii++){
    h = 0.0;
    for(i = ii; i < dpt_n; i++){
      d[i] = y[i*dpt_k+ii];
      h = h + d[i] * d[i];
    }
    if (h <= 0.0) {
      y[ii*dpt_k+ii] = 0.0;
      break;
    }
    g = sqrt(h);
    f = y[ii*dpt_k+ii];
    if (f >= 0.0) {
      g = -g;
    }
    d[ii] = f - g;
    h = h - f * g;

    for(i = ii+1; i < dpt_n; i++){
      y[i*dpt_k+ii] = 0.0;
    }
    for(j = ii+1; j < dpt_k; j++){
      s = 0.0;
      for(i = ii; i < dpt_n; i++){
	s = s + d[i] * y[i*dpt_k+j];
      }
      s = s / h;
      for(i = ii; i < dpt_n; i++){
	y[i*dpt_k+j] = y[i*dpt_k+j] - d[i] * s;
      }
    }
    y[ii*dpt_k+ii] = g;
  }
  FreeBuffer(d);
}
