#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

#include "rand_sub.h" /* by okumura */
/******************************************
      nrand(dpt,init,mean,var);
  
	dpt   : Output data points
	init  : seed
        mean  : mean
	var   : variance
        Date 28th Oct 1988 by M.Akima

       Modified for SATELITE by K.Hagiwara
       Re_Modified by T.Hayasaka
******************************************/
  
int
main()
{
  register int    i;
  int      dpt, init;
  double   mean, variance;
  Buffer   *work;
  int      dim = 1, idx[5];
  int      M[521], J;

  read_syscom();

  dpt      = idx[0] = (int)GetScalar(0);
  init     = (int)GetScalar(1);
  mean     = GetScalar(2);
  variance = GetScalar(3);
  
  if (init == 0)        exit(2);
  if (variance <= 0.0 ) exit(2);
  if (( work = AllocBuffer(dpt) ) == NULL ) exit(8);

  Gen_M_series(init, M);
  J = 0;
  
#ifdef DEBUG
  for (i = 0; i < 521; i++)
    printf("M series :%5d \n", M[i]);
#endif
  
  for (i = 0; i < dpt; i++)
    work[i] = rnd_nor(i, mean, variance, M, &J);
  
  ReturnSeries(work, dim, idx);
  write_syscom();
  return 0;
}


