#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

/****************************************************
*                                                   *
*    PHASE IBX , IBY , D , U                        *
*          IBX : REAL PART                          *
*          IBY : IMAGINARY PART                     *
*          D   : DEGREE , OTHERWISE : RADIAN        *
*          U   : UNWRAPP OR NOT                     *
*                                                   *
*  CODED BY A.Fujisaki     2,13 , 87                *
*  MODIFIED BY K.TAKEBE    APRIL 19, 1993           *
****************************************************/

#define PAI   M_PI
#define PAI2  (PAI*2)

int
main()
{
  Buffer *data1, *data2, *dat1, *dat2, *max;
  Buffer phps, phng, dif, dph, dph1, dph2;
  int	 icon, iucn, dptr, dpti, dimr, dimi;
  int    indexr[MAX_INDEX], indexi[MAX_INDEX];
  char   *ic, *iu;

  read_syscom() ;

  data1 = GetSeries(0, &dimr, indexr);
  data2 = GetSeries(1, &dimi, indexi);
  ic    = GetString(2);
  iu    = GetString(3);

  if ( data1 == NULL || data2 == NULL )
    exit( 4 );
    
  icon = -1;
  if( ic[0] == 'D' )
    icon = 1;
  
  iucn = -1;
  if( iu[0] == 'U' )
    iucn = 1;
  
  dptr = IndexSize( dimr, indexr );
  dpti = IndexSize( dimi, indexi );

  if( dptr != dpti )
    exit( 7 ) ;
  
  max = data1+dptr;

  /***** Calculation of Phase *****/
  for( dat1 = data1, dat2 = data2; dat1 < max; dat1++, dat2++ ) {
    if ( fabs(*dat1) > DBL_EPSILON || fabs(*dat2) > DBL_EPSILON )
      *dat1 = atan2( *dat2, *dat1 );
    else
      *dat1 = 0.0; 
  }

  /***** Unwrap *****/
  if ( iucn == 1 ) {
    phps = 0.0;
    phng = 0.0;
    
    for ( dat1 = data1+1, dat2 = data1; dat1 < max; dat1++, dat2++ ) {

      dif = (*dat1 + phps - phng ) - (*dat2);
      dph =  fabs( dif );
      dph1 = fabs( dif + PAI2 );
      dph2 = fabs( dif - PAI2 );
      
      if ( dph-dph1 > DBL_EPSILON )
	phps += PAI2;
      else if ( dph-dph2 > DBL_EPSILON )
	phng += PAI2;

      *dat1 += ( phps - phng ) ;
    }
  }
  
  /***** Transform from Rad. to Deg. *****/
  if ( icon == 1 )
    for ( dat1 = data1 ; dat1 < max; dat1++ )
      (*dat1) *= ( 360.0 / PAI2 );
  
  /***** Write Data to Common Area *****/
  ReturnSeries( data1, dimr, indexr ) ;
  return 0;
}
