#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*****************************************************
*	x = power(real, imag);                       *
*****************************************************/
int
main()
{
  register int    i, n;
  int             dim1, dim2, index1[MAX_INDEX], index2[MAX_INDEX];
  Buffer         *real, *imag;
  
  read_syscom();

  real = GetSeries(0, &dim1, index1);
  imag = GetSeries(1, &dim2, index2);
  
  if (real == NULL || imag == NULL) exit(4);
  if (dim1 != dim2) exit(16);
  if (!EqualIndex(index1,index2,dim1)) exit(18);
      
  /***** Calculation of ( re**2 + im**2 ) *****/
  n = IndexSize(dim1,index1);
  for (i = 0; i < n; i++)
    real[i] = real[i] * real[i] + imag[i] * imag[i];

  ReturnSeries(real, dim1, index1);
  write_syscom();
  return 0;
}
