#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

/**********************************************************
 *
 * rand_sub.c
 *
 *   double rnd_uni(double,double,int *,int *)
 *   double rnd_nor(int,double,double,int *,int *)
 *   int ISIGN(int,int)
 *   void Gen_M_series(int,int *)
 *
 *    Date Jun 24th, 2001 by Y.Okumura
 ***********************************************************/

/*
 * Uniform random data 
 */

/* #define RMXINT    32768.0 */
#define RMXINT    32767.0

double rnd_uni(double lower, double upper,int *M,int *J){
  /* M sereise initial data */

  int    k;
  double xx, xxx;
  int    temp;
  
  *J += 1;
  if (*J > 521) *J = 1;
  k = *J - 32;

  if (k <= 0)   k += 521;
  /*
   * Exclusive OR 
   */
  temp    = M[*J-1];
  M[*J-1] = temp ^ M[k-1];
  
  xx = (double) (M[*J - 1]) / (double) RMXINT;
  xxx = xx * (upper - lower) + lower;
  return (xxx);
}
  

/*
 * Normal random data 
 */
double rnd_nor(int itime,double mean,double variance,int *M,int *J){
  static double   x1, x2, s, xx1, xx2;
  static int      IC;
  double          xx, xxx;
  
  if (itime == 0)
    IC = 0;
  
  if (IC != 1) {
    do{
        x1 = rnd_uni(0., 1., M, J);
        x2 = rnd_uni(0., 1., M, J);
	xx1 = 2.0 * x1 - 1.0;
	xx2 = 2.0 * x2 - 1.0;
	s = xx1 * xx1 + xx2 * xx2;
    }
    while(s >= 1);

    xx = xx1 * sqrt(-2.0 * log(s) / s);
    IC = 1;
  } else {
    xx = xx2 * sqrt(-2.0 * log(s) / s);
    IC = 0;
  }

  xxx = xx * sqrt(variance) + mean;
  
#ifdef DEBUG
  printf("x1 :%g x2:%g xx:%g\n", x1, x2, xx);
#endif
  return (xxx);
}

/*
 * function ISGN 
 */
int ISIGN(int a,int b){
  if (a < 0)
    a *= -1;
  if (b < 0)
    a *= -1;
  return (a);
}

/* #define      NRAND     65539 */
#define      NRAND     69069

/*
 * NRAND =  16bit Machine  899 =  32bit Machine  65539 
 */
void Gen_M_series(int init_val,int M[]){
  int i, j, ix, mj, ih, ii, ij;
  int IA[521];
  
  ix = init_val;
  for (i = 0; i < 521; i++) {
    ix *= NRAND;
    IA[i] = ISIGN(1, ix);
#ifdef DEBUG
    printf("IX =%d IA()%d\n", ix, IA[i]);
#endif
  }
  
  for (j = 1; j <= 521; j++) {
    ih = ((j - 1) * 32) % 521 + 1;
    mj = 0;
    
    for (i = 1; i <= 15; i++) {
      ii = (ih + i - 2) % 521 + 1;
      mj = 2 * mj + (IA[ii - 1] - 1) / (-2);
      ij = (ii + 488) % 521 + 1;
#ifdef DEBUG
      printf("ii :%d ij :%d mj :%d\n", ii, ij, mj);
#endif
      IA[ii - 1] *= IA[ij - 1];
    }
    
    M[j - 1] = mj;
#ifdef DEBUG
    printf("M[%d] = %d \N", j - 1, M[j - 1]);
#endif
    ii = (ih + 30) % 521 + 1;
    ij = (ii + 488) % 521 + 1;
    IA[ii - 1] *= IA[ij - 1];
  }
}
