#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"
  
  /**********************************************************
   *                                                        *
   *       Rank and Rate K.E.Y                              *
   *                                                        *
   *                   Modifyed  by Naoco Toda   17,11,86   *
   *         C Version Modifyed  by T.Kobayashi  90/08/30   *
   *                                                        *
   **********************************************************/

#define PAI 3.14159265358979
  
int
main()
{
  Buffer dat, *data1, *data2, delta, work;
  int    i, idiv, jj, nn, nn1;
  int    n1, n2, n3, n4;
  int    dim, idx[MAX_INDEX];
  Buffer rkur, rmax, rmin, sam, skew, xmean, xmo3, xmo4;
  Buffer xstand, xsum, xvari, x, tau;

  read_syscom();

  /* Calculation */
  n1   = GetBufferID(0);
  n2   = GetBufferID(1);
  n3   = GetBufferID(2);
  n4   = GetBufferID(3);
  rmin = GetScalar(4);
  rmax = GetScalar(5);
  idiv = (int)GetScalar(6);
  
  /* Parameter Set */
  if ( rmin >= rmax )
    exit(2);
  if (idiv < 1)
    exit(2);
  
  data1 = ReadBuffer( n1, &dim, idx );
  nn1   = IndexSize( dim, idx );

  delta = (rmax - rmin) / (double)idiv;
  
  xsum = 0.0;
  for (i = 0; i < nn1; i++)
    xsum += data1[i];
  xmean = xsum / (double) nn1;
  
  xsum = 0.0;
  for (i = 0; i < nn1; i++) {
    work = data1[i] - xmean;
    xsum += work * work;
  }
  
  xvari = xsum / (double)nn1;
  xstand = sqrt(xvari);
  
  if (xstand <= 0.0) {
    xmo3 = 0;
    xmo4 = 0;
    skew = 0;
    rkur = 0;
  } else {
    xsum = 0.0;
    for (i = 0; i < nn1; i++) {
      work = data1[i] - xmean;
      xsum += work * work * work;
    }
    xmo3 = xsum / (double)nn1;
    skew = xmo3 / (xstand * xstand * xstand);
    
    xsum = 0.0;
    for (i = 0; i < nn1; i++) {
      work = data1[i] - xmean;
      xsum += work * work * work * work;
    }
    xmo4 = xsum / (double)nn1;
    rkur = (xmo4 / (xstand * xstand * xstand * xstand)) - 3.0;
  }
  
  printf(" ** MEAN VALUE = %15.5g\n", xmean);
  printf("    VARIANCE   = %15.5g\n", xvari);
  printf("    STANDARD D = %15.5g\n", xstand);
  printf("    3-ORDER M  = %15.5g\n", xmo3);
  printf("    SKEWNESS   = %15.5g\n", skew);
  printf("    4-ORDER M  = %15.5g\n", xmo4);
  printf("    KURTOSIS   = %15.5g\n", rkur);

  
  /* Axis */
  nn = idiv * 2 + 2;
  idiv = idiv + 1;

  if (( data2 = AllocBuffer( nn ) ) == NULL ) 
    exit(8);
  
  for (i = 0; i < idiv; i++) {
    jj = i * 2;
    dat = delta * (double)i + rmin;
    data2[jj] = dat;
    data2[jj + 1] = dat;
  }
  dim = 1;
  idx[0] = nn;
  if ( WriteBuffer( n3, dim, idx, data2 ) == -1 ) exit(3);
  
  for (i = 0; i < nn; i++)
    data2[i] = 0.0;
  for (i = 0; i < nn1; i++) {
    if (data1[i] < rmin || data1[i] > rmax)
      continue;
    jj = (int)((data1[i] - rmin) / delta);
    jj = jj * 2 + 1;
    dat = data2[jj] + 1.0;
    data2[jj] = dat;
    data2[jj + 1] = dat;
  }
  dim = 1;
  idx[0] = nn;
  if ( WriteBuffer( n2, dim, idx, data2 ) == -1 ) exit(3);
  
  for (i = 0; i < idiv; i++) {
    x = rmin + (double)i *delta;
    jj = 2 * i;
    if (xvari != 0.0)
      tau = (x - xmean) * (x - xmean) / (2.0 * xvari);
    else
      tau = 70.0;
    if (tau > 69.0)
      sam = 0.0;
    else {
      sam = (double) nn1 *exp(-tau);
      sam /= sqrt(2.0 * PAI * xvari);
      sam *= delta;
    }
    data2[jj]     = sam;
    data2[jj + 1] = sam;
  }
  dim    = 1;
  idx[0] = nn;
  if ( WriteBuffer( n4, dim, idx, data2 ) == -1 ) exit(3); 
 
  ReturnScalar(xmean);
  write_syscom();
  return 0;
}
