#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"


/*****************************************************
*      SHIFT Y - AXIS                                *
*----------------------------------------------------*
*       YSHIFT B1,B2,INDEX,LEVEL                     *
*          B1 : Input Buffer Number                  *
*          INDEX : Data Point or Cursor[C]           *
*          LEVEL : Shift Level                       *
*----------------------------------------------------*
*                    1986 , 8 , 27                   *
*                    1989 , 8 , 27  T.Kobayashi      *
*                    1993 , 4 , 17  K.Takebe         *
******************************************************/

int
main()
{
  int      index1[MAX_INDEX], index2[MAX_INDEX], index3[MAX_INDEX];
  int      dim1, dim2, l, i;
  Buffer  *x, *y, z, data, m;

  read_syscom();

  if ((x = GetSeries(0, &dim1, index1 )) == NULL) exit(4);
  if ((y = GetSeries(1, &dim2, index2 )) == NULL) {
    y         = AllocBuffer(1);
    y[0]      = GetScalar  (1);
    index2[0] = 1;
  }
  z = GetScalar(2);

  if ( index2[0] != dim1 ) exit(16);

  for ( i = 0; i < dim1; i++ ) {
    if ( index1[i] <= (int)y[i] || (int)y[i] < 0 ) {
      printf("illegal value of index\n");
      exit(2);
    }
    index3[i] = (int)y[i];
  }
  if ( dim1 == 1 )
    data = x[ index3[0] ];
  else
    data = x[ Index( index3, dim1, index1 ) ];

  l = IndexSize( dim1, index1 );
  m = z - data;
  for ( i = 0; i < l; i++ )
    x[i] += m;

  ReturnSeries( x, dim1, index1 );
  return 0;
}
