#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"
#include "SLfloat.h"

/*****************************************************
*   Power Spectrum by FFT                            *
*----------------------------------------------------*
*   SPCF  IBUF1 , IBUF2 , IBUF3                      *
*       IBUF1 : input data                           *
*       IBUF2 : output data (power)                  *
*       IBUF3 : output data (phase)                  *
*----------------------------------------------------*
*                       1986, 6, 25                  *
*            C Version  1989,10,  5  T. Kobayashi    *
*                       1993, 9, 14  K. Takebe       *
*****************************************************/

#define PAI  M_PI
#define PAI2 (PAI*2.0)

static int  sspec _ANSI_ARGS_((Buffer *xr, Buffer *xi,
			       Buffer *pw, Buffer *ph, int dpt));

/* in fft_sub.c */
extern int  fft1  _ANSI_ARGS_((double *ar, double *ai, int n, int flag ));

int
main()
{
  Buffer *xr, *xi, *max, *xxi;
  Buffer *Power, *Phase;
  int	 nn1, ob1, ob2, nn2;
  int    dim, idx[MAX_INDEX];
  
  read_syscom();
  
  if (( xr = GetSeries( 0, &dim, idx ) ) == NULL )
    exit(4);
  nn1 = IndexSize( dim, idx );
  if ( dim != 1 )
    exit(2);

  if (( xi = AllocBuffer(nn1) ) == NULL )
    exit(8);

  ob1 = GetBufferID(1);
  ob2 = GetBufferID(2);
  if ( ob1 <= 0 || ob2 <= 0 )
    exit(2);

  Power = xr;
  Phase = xi;

  max = xi + nn1;
  for( xxi = Phase; xxi < max; xxi++ )
    (*xxi) = 0.0;
  
  fft1( xr, xi, nn1, 0 );
  
  nn2 = sspec( xr, xi, Power, Phase, nn1 );
  
  dim = 1;
  idx[0] = nn2;
  if ( WriteBuffer( ob1, dim, idx, Power ) == -1 ) exit(3);
  if ( WriteBuffer( ob2, dim, idx, Phase ) == -1 ) exit(3);

  write_syscom(); 
  return 0;
}


static int
sspec( Buffer *xr, Buffer *xi, Buffer *pw, Buffer *ph, int dpt)
    /*--------------------------------
      Subroutine sspec
      
      xr : Real Data 
      xi : Imagenary Data
      pw : Power
      ph : Phase
      dpt: Calc Data Point
      
      return dpt 
      ---------------------------------*/
{
  double dif, dph, dph1, dph2;
  double phps, phng;
  double real, imag;
  int	 m, i, i1;
  double samf;
  
  samf = (double)get_sampling();
  
  if( samf <= 0.0 )
    exit( 21 );
  
  m = dpt / 2 + 1;
  
  for( i = 0; i < m; i ++ ) {
    real = xr[ i ];
    imag = xi[ i ];
    
    pw[ i ] = ( real * real + imag * imag )/ ( (1.0/samf) * (Buffer)dpt );
    
    if( fabs(real) > DBL_EPSILON || fabs(imag) > DBL_EPSILON )
      ph[ i ] = atan2( imag, real );
    else {
      ph[ i ] = 0.0;
    }
  }
  
  phps = phng = 0.0;
  
  for( i = 1; i < m; i ++ ) {
    i1   = i - 1;
    dif  = ph[ i ] - ph[ i1 ] + phps - phng;
    dph  = fabs( dif );
    dph1 = fabs( dif + PAI2 );
    dph2 = fabs( dif - PAI2 );
    
    if( dph > dph1 ) {
      phps += PAI2;
    } else if ( dph > dph2 ) {
      phng += PAI2;
    }    
    ph[ i ] += ( phps - phng );
  }
  
  for( i = 0; i < m; i ++ ) ph[ i ] *= ( 180.0 / PAI );
  
  return m;
}
