#include <stdio.h>
#include <string.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/*
 * yip = spline(xin, yin, xip | dpt [, xip])
 *
 * It should be x[0] < x[1] < ... < x[n-1] in xin, xip 
 * 
 *   coded by K.Takebe
 *   modified by T.Hayasaka (07/31/2001)
 */

static int spline _ANSI_ARGS_((double *xa, double *ya, int n,
			       double *x,  double *y,  int m ));

int
main()
{
  int      args    = 0;
  int      dimx, idxx[MAX_INDEX];
  int      dimy, idxy[MAX_INDEX];
  int      dimo, idxo[MAX_INDEX]; 
  int      outx_id = 0;
  int      i, n, fmode = 0, imode = 0;
  int      dpt = 0;
  Buffer  *xa, *ya, DI;
  Buffer  *xo = NULL, *yo = NULL;

  read_syscom();
	
  args = GetArgNum();
  if (( xa = GetSeries(0, &dimx, idxx )) == NULL )       exit(4);
  if (( ya = GetSeries(1, &dimy, idxy )) == NULL )       exit(4);
  if ( dimx != 1 ) exit(24); 
  if ( dimx != dimy || idxx[0] != idxy[0] ) exit(16);

  n = idxx[0];
  for ( i = 0; i < n-1; i++ )
    if ( xa[i] >= xa[i+1] ) exit(26); 


  if ( strcmp(GetArgType(2),"series") == 0 ) {
    if ((xo  = GetSeries(2, &dimo, idxo )) == NULL ) exit (17);
    if ( dimo != 1  ) exit(24);
    dpt = idxo[0];
    for ( i = 0; i < dpt-1; i++ )
      if ( xo[i] >= xo[i+1] ) exit(26); 
    imode = 0;
  } else {
    dimo = 1;
    dpt  = (int)GetScalar(2);
    imode = 1;
  }
  if ( args > 3 ) {
    if (( outx_id = GetBufferID(3) ) <= 0 ) exit(17);
    if ( imode == 1 ) imode = 2;
  }

  if ( dpt <= 0 ) {
    fmode = 1;
    dpt   = (int)((xa[n-1]-xa[0])*get_sampling()) + 1;
  }
  
  if ((yo = CAllocBuffer(dpt)) == NULL) exit(8);

  if ( imode != 0 ) {
    if ((xo  = CAllocBuffer(dpt)) == NULL ) exit(8);

    DI = (fmode) ? 1.0/get_sampling() : 
      ((dpt > 1) ? (xa[n-1]-xa[0])/(double)(dpt-1) : 0.0);
    for ( i = 0; i < dpt; i++ )
      xo[i] = (double)i * DI + xa[0];
  }

  if ( xa[0] > xo[0] || xa[n-1] < xo[dpt-1])   exit(27);
  if ( spline(xa, ya, n, xo, yo, dpt) != 0 ) exit(25);

  idxo[0] = dpt;
  ReturnSeries( yo, dimo, idxo );
  if ( outx_id > 0 )
    if ((WriteBuffer( outx_id, dimo, idxo, xo )) == -1 ) exit(3);

  write_syscom();
  return 0;
}


static int spline(double *xa, double *ya, int n,
		  double *x,  double *y,  int m )
{
  int i, j, idx, nn;
  double *s, *a0, *a1, *a2, *a3, *b, *a, *g;
  double tmp, h, dx1, dx2, dy1, dy2;

  nn = n - 2;

  if ( n < 3 || xa == NULL || ya == NULL || x == NULL || y == NULL )
    return -1;

  if ((a0 = (double *)malloc(sizeof(double)*(nn+1))) == NULL)
    return -2;
  if ((a1 = (double *)malloc(sizeof(double)*(nn+1))) == NULL)
    return -2;
  if ((a2 = (double *)malloc(sizeof(double)*(nn+1))) == NULL)
    return -2;
  if ((a3 = (double *)malloc(sizeof(double)*(nn+1))) == NULL)
    return -2;
  if ((s  = (double *)malloc(sizeof(double)*(nn+2))) == NULL)
    return -2;
  if ((a  = (double *)malloc(sizeof(double)*(nn+2))) == NULL)
    return -2;
  if ((b  = (double *)malloc(sizeof(double)*(nn+2))) == NULL)
    return -2;
  if ((g  = (double *)malloc(sizeof(double)*(nn+2))) == NULL)
    return -2;

  for ( i = 1; i <= nn; i++ ) {
    dx1 = xa[i] - xa[i-1];
    dx2 = xa[i+1] - xa[i];
    dy1 = (ya[i+1] - ya[i]) / dx2;
    dy2 = (ya[i] - ya[i-1]) / dx1;

    a0[i] = dx1 / (dx1 + dx2);
    a1[i] = 2.;
    a2[i] = 1. - a0[i];
    a3[i] = 6. * ((dy1-dy2) / (dx1+dx2));
  }

  for ( i = 1; i < nn; i++ ) {
    a2[i] = a2[i] / a1[i];
    a3[i] = a3[i] / a1[i];
    a1[i+1] = a1[i+1] - a0[i+1]*a2[i];
    a3[i+1] = a3[i+1] - a0[i+1]*a3[i];
  }

  s[nn] = a3[nn] / a1[nn];

  for ( i = nn-1; i >= 1; i-- ) {
    s[i] = a3[i] - a2[i] * s[i+1];
  }
  s[0] = s[nn+1] = 0.;

  for ( i = 0; i <= nn; i++ ){
    h = xa[i+1] - xa[i];
    b[i] = s[i] / 2.;
    g[i] = (s[i+1] - s[i]) / (6. * h);
    a[i] = (ya[i+1] - ya[i])/h - b[i]*h - g[i]*h*h;
  }
 
  for ( i = 0; i < m; i++ ) {
    idx = n-1; 
    for ( j = 0; j < n-1; j++ ) {
      if ((xa[j] <= x[i]) && (xa[j+1] > x[i]))
        idx = j;
    }

    tmp = x[i] - xa[idx];
    y[i] = ya[idx] + a[idx]*tmp + b[idx]*tmp*tmp + g[idx]*tmp*tmp*tmp;
  }

  free(g);
  free(b);
  free(a);
  free(s);
  free(a3);
  free(a2);
  free(a1);
  free(a0);
  
  return 0;
}

