/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : trans          *
*    ( Ver 1.0 : 1993/03/09 )  *
********************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

void trans( Buffer *x, Buffer *y, int dp1, int dp2 ){
  int k, i, dpt;

  for ( k = 0; k < dp1; k++ ) {
    dpt = dp2*k;
    for ( i = 0; i < dp2; i++ )
      y[ dp1*i+k ] = x[ i+dpt ];
  }
}

int
main()
{
  Buffer *x, *y, *xx, *yy, *max;
  int    idx[MAX_INDEX],idx2[MAX_INDEX];
  int    dim, m, n, i, l;

  read_syscom();
  x = GetSeries( 0, &dim, idx);
  if ( x == NULL )
    exit(4);

  if ( dim == 1 ) {
    dim = 2;
    idx[1] = idx[0];
    idx[0] = 1;
  }

  l = IndexSize( dim, idx );
  if (( y = AllocBuffer( l ) ) == NULL )
    exit(8);

  m = idx2[dim-1] = idx[dim-2];
  n = idx2[dim-2] = idx[dim-1];

  for ( i = 0; i < dim-2; i++ )
    idx2[i] = idx[i];

  max = x+l;
  i   = m*n;

  for ( xx = x, yy = y; xx < max; xx+=i, yy+=i )
    trans( xx, yy, m, n );


  ReturnSeries( y, dim, idx2 );
  FreeBuffer( y );
  FreeBuffer( x );
  return 0;
}

