#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "rand_sub.h" /* by okumura */
/******************************************
  
      "URAND  DPT , INIT , LOWER , UPPER "
  
	DPT   : output data point
	INIT  : initial value
        LOWER : lower value
	UPPER : upper value
  
        Date 28th Oct 1988 by M.Akima
	Modified by S.Hitomi Jul. 24, 1992
******************************************/

int
main()
{
  int          dpt;
  int          init;
  double       lower, upper;
  Buffer       *work;
  register int i;
  int          dim = 1, idx[MAX_INDEX];
  
  int          M[521], J;
  
  read_syscom();

  idx[0] = dpt = (int)GetScalar(0);
  init = (int)GetScalar(1);
  lower = GetScalar(2);
  upper = GetScalar(3);

  if (( work = AllocBuffer(dpt) ) == NULL )
    exit(4);

  Gen_M_series(init, M);
  J = 0;
  
#ifdef DEBUG
  for (i = 0; i < 521; i++)
    printf("M series :%5d \n", M[i]);
#endif
  
  for (i = 0; i < dpt; i++)
    work[i] = rnd_uni(lower, upper, M, &J);
  
  ReturnSeries(work, dim, idx);
  write_syscom();
  return 0;
}
