#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "macro.h"

#include <stdio.h>
#include <ctype.h>
#include <string.h>

/*
 * Bcopy is sorta like bcopy() except that we handle overlap between source
 * and destination memory
 */

void
Bcopy(src, dst, length)
     register char  *src, *dst;
     register int    length;
{
  if (src == dst)
    return;
  if (src > dst) {
    while (length--) {
      *dst++ = *src++;
    }
  } else {
    src += length;
    dst += length;
    while (length--) {
      *--dst = *--src;
    }
  }
}
