#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#else
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#endif

#include <stdio.h>

float *
buff_alloc()
{
  return ((float *) malloc(syscom.buff_leng * sizeof(float)));
}

void
buff_free(p)
     float  *p;
{
  free(p);
}

int
buff_init(n, dim, idx)
     int  n, dim, *idx;
{
  return InitBuffer(n, dim, idx);
}

int
buff_write(n, area, length, idx)
     int     n, length, *idx;
     float  *area;
{
  register int    i;
  int             dim = 1, status, need_free = 0;
  Buffer         *warea;
  if (idx == NULL) {
    idx = (int *) malloc(sizeof(int));
    *idx = length;
    need_free = 1;
  }
  warea = AllocBuffer(length);
  for (i = 0; i < length; i++ ) {
    warea[i] = (Buffer) area[i];
  }
  
  status = WriteBuffer(n, dim, idx, warea);
  FreeBuffer(warea);
  if (need_free)
    free(idx);
  return status;
}


int
buff_read(n, area, idx)
     int     n, *idx;
     float  *area;
{
  register int    i;
  int             dim = 1, length, need_free = 0;
  Buffer         *warea;

  if (idx == NULL) {
    idx = (int *) malloc(sizeof(int)*16);
    need_free = 1;
  }

  warea = (Buffer *) ReadBuffer(n, &dim, idx);
  if (warea != NULL) {
    length = Min(syscom.buff_leng, idx[0]);
    for (i = 0; i < length; i++)
      area[i] = (float) warea[i];
    FreeBuffer(warea);
  } else
    length = -1;

  if ( need_free == 1 )
    free(idx);

  return length;
}


int
buff_info(n, idx)
     int  n, *idx;
{
  if (idx == NULL) {
    int tmp = 0;
    idx = (int *) malloc(sizeof(int)*16);
    tmp = GetBufferInfo(n, idx);
    tmp = ( tmp <= 1 ) ? idx[0] : IndexSize(tmp, idx);
    free(idx);
    return tmp;
  }

  return GetBufferInfo(n, idx);
}


void
buff_append(n, area, length)
     /* ATTENTION  1D ONLY */
     int     n, length;
     float  *area;
{
  register int    i;
  int		num;
  float          *work;

  work = buff_alloc();

  num = buff_read(n, work, NULL);
  if (num == -1)
    num = 0;

  for (i = 0; i < length; i++)
    work[num + i] = area[i];

  num += length;

  buff_write(n, work, num, NULL);
  buff_free(work);
}
