#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "SL_macro.h"

#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#else
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#endif


char *
emalloc(n)		/* check return from malloc */
     unsigned  n;	/* size of memory allocation */
{
  char  *p = (char*)malloc(n);

#ifdef DEBUG
  fprintf(stderr,"in LIB/emalloc.c: malloc()\n");
#endif

  if (n == 0)
    perror("malloc: illegal request size (0 byte)");
  if (p == NULL)
    perror("out of memory");
  return p;
}

char *
erealloc(p, n)			/* check return from malloc */
     char      *p;
     unsigned   n;
{
  char   *rp = (char*)realloc(p, n);

#ifdef DEBUG
  fprintf(stderr,"in LIB/emalloc.c: erealloc()\n");
#endif

  if (n == 0)
    perror("realloc: illegal request size (0 byte)");
  if (rp == NULL)
    perror("out of memory");
  return rp;
}


void
efree(p)
     char *p;
{

#ifdef DEBUG
  fprintf(stderr,"in LIB/emalloc.c: efree()\n");
#endif

  if (p != NULL)
    free(p);
}
