/***** SATELLITE-LANG New Data File Header *****/
typedef struct {
        char            type_flag;      /* File Format Flag            */
        char            data_size;      /* Size of a data              */
        char            opr_name[30];   /* Operator Name               */
        char            comment[128];   /* Comment Area                */
        char            date[3];        /* Date of Making              */
        char            dim;            /* Dimension                   */
        int             index[10];      /* Number of Data              */
        float           samf;           /* Sampling Frequency          */
        char            free[48];       /* free area                   */
}               Header;


char           *ReadFile(char *f_name, Header * head);
int             WriteFile(char *f_name, int dim, int *index, char *data);

char           *LoadData(char *f_name, int numb, Header * head);
int             StoreData(char *f_name, int numb, int dim, int *index, char *data);

Buffer *
load()
{
	char	*fname = "test.dat";	/* filename */
	int	numb = 1;		/* recode number */
	Header head;			/* header */
	Buffer	*buf;

	if (exist_index) 
		buf = (char *) LoadData(fname, numb, &head);
	else 
		buf = (char *) ReadFile(fname, &head);
	if (buf == NULL)
		execerror("failed to evaluate", fname);
	return buf;
}


store()
{
	char *fname = "test.dat";
	int	dim, numb;
	int	index[10];
	Buffer  data[1024];
	int	status;

	if (exist_index)
		status = StoreData(fname, numb, dim, index, (char *)data);
	else
		status = WriteFile(fname, dim, index, (char *)data);
	if (status == -1)
		execerror("data file write error :", fname);
}
