/**********************************************************************
        get_p.c : Parts of Stack Machine Code
			(UNIX parts)

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "macro.h"
#include "syscom.h"

#include <stdio.h>
#include <string.h>


int
get_p(nprm, str_size, str, integer, real)
     int     nprm, str_size;
     char   *str;
     int    *integer;
     float  *real;
{
  int  i, status = TRUE;

  if (nprm > NARG) {
    nprm   = NARG;
    status = FALSE;
  }

  if (str != NULL)
    for (i = 0; i < nprm; i++) {
      char  *s = syscom.strings[i];
      char  *p = str + i * str_size;
      strcpy(p, s);
    }
  
  if (integer != NULL)
    for (i = 0; i < nprm; i++)
      integer[i] = (int) syscom.values[i];
  
  if (real != NULL)
    for (i = 0; i < nprm; i++)
      real[i]    = (float) syscom.values[i];

  return status;
}

/**********************************************************************
	End of Stack Machine Code (UNIX parts)
***********************************************************************/
