#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "SL_macro.h"

#include <stdio.h>

#ifndef Max
#define Max(a,b)	((a)>(b)?(a):(b))
#endif
#ifndef Min
#define Min(a,b)	((a)<(b)?(a):(b))
#endif


int
RegularIndex(idx2, idx, n)
     int  *idx2, *idx, n;
{
  register int	i;

  if(idx2 == NULL)
    return 0;

  for(i = 0; i < n; i++) {
    if(0 > idx2[i] || idx2[i] >= idx[i] )
      return 0;
  }
  return 1;
}

int
CopyIndex(to, from, n)
     int *to, *from, n;
{
  register int    i;

  for(i = 0; i < n; i++)
    to[i] = from[i];
  return n;
}

int
EqualIndex(to, from, n)
     int     *to, *from, n;
{
  register int    i;

  for(i = 0; i < n; i++) {
    if(to[i] != from[i])
      return 0;			/* FALSE */
  }

  return 1;			/* TRUE */
}

int
IndexSize(dim, idx)
     int   dim;
     int  *idx;
{
  register int	i, siz = 1;

  if(dim == 0 || idx == 0)
    return 0;

  for(i = 0; i < dim; i++)
    siz *= idx[i];

  return siz;
}

int *
SubIndex(idx)
     register int  *idx;
{
  return idx + 1;
}


int
Index(idx2, dim, idx)
     int  *idx2;
     int   dim;
     int  *idx;
{
  register int	i, fac = 1, n = 0;

  if(dim == 0)
    return 0;

  for(i = dim - 1; i >= 0; i--) {
    n += fac * idx2[i];
    fac *= idx[i];
  }
  return n;
}

int *
rIndex(n, idx2, dim, idx)
     register int  n;       /* data point    */
     int	*idx2;    /* index of data */
     int	dim;	    /* demension of data */
     int	*idx;	    /* range of index */
{
  register int	i, siz;
  siz = (dim == 1) ? 1 : IndexSize(dim - 1, SubIndex(idx));
  for(i = 0; i < dim; i++) {
    idx2[i] = n / siz;
    n %= siz;
    if(siz != 1)
      siz /= idx[i+1];
  }	
  return idx2;
}

void
MaxIndex(a, b, idx, dim)
     int  *a, *b, *idx, dim;
{
  register int i;
  for(i = 0; i < dim; i++) 
    idx[i] = Max(a[i], b[i]);
}

void
MinIndex(a, b, idx, dim)
     int  *a, *b, *idx, dim;
{
  register int i;
  for(i = 0; i < dim; i++) 
    idx[i] = Min(a[i], b[i]);
}

#if 0
main(argc, argv)
     int    argc;
     char **argv;
{
  register int i;
  int	dim, idx[10], idx2[10], length;

  dim = 3;
  idx[0] = 4;
  idx[1] = 2;
  idx[2] = 6;
  for(i = 0; i < dim; i++)
    printf("[%d]", idx[i]);
  puts("");
	
  printf("index size = %d\n", IndexSize(dim, idx));
  if(argc == 1)
    return;
  for(i = 1; i < argc; i++)  { 
    idx2[i - 1] = atoi(argv[i]);
  }
  printf("dpoint = %d\n", length = Index(idx2, dim, idx));


  bzero(idx2, sizeof(int)*10);

  rIndex(length, idx2, dim, idx);
  for(i = 0; i < dim; i++)
    printf("[%d]", idx2[i]);
  puts("");
}
#endif

