/**********************************************************************
	Input Procedure : input.y	(yacc format)	
***********************************************************************/
%{
#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#include "SL_config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

static double   value;
static char     stream[256];
static char    *streamptr = stream;

static int yylex();
static int yyerror();
static int warning();
static int execerror();
%}
%union {	/* stack type */
  double  val;	/* actual value */
}
%token	<val>	NUMBER
%type	<val>	expr
%right	'='
%left	'+'	'-'
%left	'*'	'/'
%left	UNARYMINUS	
%right  '^'                     /* exponentiation */
%%
list:	/* nothing */
	| list		'\n'
	| list expr	'\n'	{ value = $2; return 0; }
	| list error	'\n'	{ yyerrok; printf("> "); return 1; }	
	;
expr:	NUMBER		
	| expr '+' expr	{ $$ = $1 + $3; }
	| expr '-' expr	{ $$ = $1 - $3; }
	| expr '*' expr	{ $$ = $1 * $3; }
	| expr '/' expr	{ 
		if ($3 == 0.0)
			execerror("division by zero", "");
		$$ = $1 / $3; }
	| '(' expr ')'	{$$ = $2; }
	| '-' expr %prec UNARYMINUS { $$ = - $2; }
	| expr '^' expr { $$ = pow($1, $3); }
	;
%%
	/* end of grammar */

#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <setjmp.h>

static sigjmp_buf begin;
static int	c;

static int
yylex()
{

  while ((c = *streamptr++) == ' ' || c == '\t')
    ;
  if (c == EOF)
    return 0;
  if (c == '.' || isdigit(c)) { /* number */
    double          d;
    char            sbuf[100], *getnum(), *next;
    int             len;

    --streamptr;		/* '.' or digit return to stream */

    next = getnum(streamptr);	/* (*next) is not a number */
    len = next - streamptr;	/* length of number's string */
    if (len == 0)
      return c;

    sbuf[len] = '\0';
    strncpy(sbuf, streamptr, len); /* number's strings into sbuf */

    sscanf(sbuf, "%lf", &d);	/* string to number */
    streamptr = next;		/* set next pointer */

    yylval.val = d;
    return NUMBER;
  }
  return ( c == '\0' ) ? '\n' : c;
}

static int
yyerror(s)	/* called for yacc syntax error */
     char  *s;
{
  warning(s, (char *)0);

  return 0;
}


static int
warning(s, t)	/* print warning message */
     char  *s, *t;
{
  fprintf(stderr, "%s", s);
  if (t)
    fprintf(stderr, " %s", t);
  fprintf(stderr, " near  '%c'\n", c);

  return 0;
}


static int
execerror(s, t)		/* recover from run-time error */
     char *s, *t;
{
  warning(s, t);
  siglongjmp(begin, 1);

  return 0;
}

static int
fpecatch()		/* chatch floating point exceptions */
{
  execerror("floating point exception", (char *)0);

  return 0;
}


int
_input_(str_size, str, integer, real)
     int	str_size;
     char	*str;
     int	*integer;
     float	*real;
{
  int	status = 1;

  if(sigsetjmp(begin,1) == 1)
    printf("> ");
  signal(SIGFPE, (RETSIGTYPE (*)())fpecatch);

  do {
    if(fgets(stream, str_size, stdin) == NULL)	/* get a one line */
      *stream = EOF;
    streamptr = stream;
  } while(yyparse());

  if(str != NULL) {
    if(strlen(stream) < str_size)
      strcpy(str, stream);
    else {
      strncpy(str, stream, str_size);
      str[str_size - 1] = (char)0;
    }
  }

  if(integer != NULL)
    *integer = (int) value;
		
  if(real != NULL)
    *real = (float) value;

  return !status;
}
/**********************************************************************
	End of Input Procedure
***********************************************************************/
