#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "SL_macro.h"

#include <stdio.h>
#include <ctype.h>

#define	getint()  while(isdigit((int)*streamptr)) streamptr++/* ; */

static char   *
exponent(stream)
     char  *stream;
{
  char   c, *streamptr = stream;

  /* e, E */
  if ((c = *streamptr) != 'e' && c != 'E')
    return stream;		/* not accept */

  streamptr++;
  /* +, - */
  if ((c = *streamptr) != '+' && c != '-' && !isdigit((int)c))
    return stream;		/* not accept */

  if (!isdigit((int)c))
    streamptr++;

  /* Exponent */
  if (isdigit((int)*streamptr)) {
    getint();
    return streamptr;		/* accept */
  } else
    return stream;		/* not accept */
}

char  *
getnum(stream)
     char  *stream;
{
  char  *streamptr = stream;

  /* Float */
  /* integer */
  getint();

  if (*streamptr == '.') {	/* decimal point */
    streamptr++;
    getint();			/* decimal */
  }
  /* if '.' only */
  if (stream[0] == '.' && stream + 1 == streamptr)
    return stream;		/* not accept */

  streamptr = exponent(streamptr);
  return streamptr;
}






#if 0

main()
{
  print("ABCDEFGIHJKLMN");
  print(".ABCDEFGIHJKLMN");

  print(".");
  print("..");
  print(".0");
  print(".0e0");
  print(".e");
  print(".e0");

  print("+123");
  print("-123");
  print("0000012345");

  print("123");
  print("123e");
  print("123e5");
  print("123e+5");
  print("123e-5");

  print("0.");
  print("1234.eee");
  print(".12345");
  print("123.45");
  print("123.45exp");
  print("123.E5");
  print("123.45E5");
  print("123.45E+5");
  print("123.45E-5");

  print(".123.122");
  print(".123e");
  print(".123eabcdefg");
  print(".123e-abcdefg");
  print(".123e+4w");
  print(".123e+4.");
}


print(str)
     char  *str;
{

  int    len;
  char  *next = str;
  char   num[40];

  printf("(%-15s)\t", str);

  next = getnum(str);
  len = next - str;

  printf("len = %2d\t", len);
  num[len] = NULL;
  strncpy(num, str, len);

  printf("number[%-10s]\t", num);
  printf("next[%s]\n", next);
}
#endif
