/**********************************************************************
        protocol.c : Parts of Stack Machine Code

			Coded by Shigeru Hitomi  May. 4, 1992
***********************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "macro.h"
#include "syscom.h"

#include <stdio.h>
#include <string.h>

/*********************************************************************
        Get System Common Value
*********************************************************************/
int
GetArgNum()
{
  return syscom.narg;
}

char *
GetArgType(n)
    int n;
{
  return syscom.types[n];
}  

/**********************************************************************
	Get Objects
**********************************************************************/
int
GetBufferID(n)
    int n;
{
  char *type = syscom.types[n];
  int     ID = 0;
  
  if (n > NARG)
    fprintf(stderr, "WARNING: too may required arguments.\n");
  else if (equal(type, "series") || equal(type, "snapshot"))
    ID = (int)syscom.values[n];

  return ID;
}

double
GetScalar(n)
    int n;
{
  double  retval = 0.0;

  if (n > NARG)
    fprintf(stderr, "WARNING: too may required arguments.\n");
  else
    retval = syscom.values[n];

  return retval;
}

char *
GetString(n)
    int n;
{
  char *retval = NULL;

  if (n > NARG)
    fprintf(stderr, "WARNING: too may required arguments.\n");
  else
    retval = syscom.strings[n];

  return retval;
}


Buffer *
GetSeries(n, dim, idx)
    int n, *dim, *idx;
{
  Buffer *retval = NULL;
  char   *type;

  if (n > NARG)
    fprintf(stderr, "WARNING: too may required arguments.\n");
  else {
    type = syscom.types[n];
    if (equal(type, "series") || equal(type, "snapshot"))
      retval = ReadBuffer((int) syscom.values[n], dim, idx);
  }
  return retval;
}


Buffer *
GetSnapshot(n, dim, idx)
    int n, *dim, *idx;
{
  Buffer  *retval = NULL;
  char    *type;

  if (n > NARG)
    fprintf(stderr, "WARNING: too may required arguments.\n");
  else {
   type = syscom.types[n];
   if (equal(type, "series") || equal(type, "snapshot"))
      retval = ReadBuffer((int) syscom.values[n], dim, idx);
  }
  return retval;
}


/**********************************************************************
	Put Objects
**********************************************************************/

void
ReturnSeries(buf, dim, idx)
    Buffer *buf;
    int    dim, *idx;
{
  static   int i = 0;
  int          n = NextBuffer();

  int     status = 0, j = 0;

  /* data check */
  if (dim <= 0 || dim > MAX_INDEX) {
    fprintf(stderr,"ReturnSeries(): Illegal dimension\n");
    status = 1;
  }
  if (idx == NULL)  {
    fprintf(stderr,"ReturnSeries(): Illegal index array\n");
    status = 1;
  } else {
    for (j = 0; j < dim; j++) {
      if (idx[j] < 0) {
	fprintf(stderr,"ReturnSeries(): Illegal index\n");
	status = 1;
	break;
      }
    }
  }

  if ( status == 0 ) {
    WriteBuffer(n, dim, idx, buf);
    strcpy(syscom.return_type, "series");
    if (i < NARG)
      syscom.return_values[i++] = (double) n;
    write_syscom();
  }
  return;
}


void
ReturnScalar(sc)
    double sc;
{
  strcpy(syscom.return_type, "scalar");
  syscom.return_values[0] = sc;
  write_syscom();
  return;
}


void
ReturnSnapshot(buf, dim, idx)
    Buffer *buf;
    int    dim, *idx;
{
  static int i = 0;
  int        n = NextBuffer();

  int     status = 0, j = 0;

  /* data check */
  if (dim <= 0 || dim > MAX_INDEX) {
    fprintf(stderr,"ReturnSnapshot(): Illegal dimension\n");
    status = 1;
  }
  if (idx == NULL)  {
    fprintf(stderr,"ReturnSnapshot(): Illegal index array\n");
    status = 1;
  } else {
    for (j = 0; j < dim; j++) {
      if (idx[j] < 0) {
	fprintf(stderr,"ReturnSnapshot(): Illegal index\n");
	status = 1;
	break;
      }
    }
  }
  if (status == 0 ) {
    WriteBuffer(n, dim, idx, buf);
    strcpy(syscom.return_type, "snapshot");
  
    if (i < NARG)
      syscom.return_values[i++] = (double) n;
    write_syscom();
  }
  return;
}


void
ReturnString(str)
    char *str;
{
  strcpy(syscom.return_type, "string");

  if (str != NULL ) {
    if (strlen(str) > ONE_LINE)
      str[ONE_LINE-1] = '\0';

    strcpy(syscom.return_strings[0], str);
  } else
    strcpy(syscom.return_strings[0], "");
  
  write_syscom();
  return;
}

/**********************************************************************
	End of Stack Machine Code (UNIX parts)
***********************************************************************/
