/*******************************************************************
 **                                                               **
 **      File Name : qsort.c                                      **
 **                                                               **
 **                 Quick Sort Subroutine                         **
 **                  for SATELLITE Basic Library                  **
 **                                      Coded by T.Kobayashi     **
 **                                                               **
 *******************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "SL_macro.h"

#include <stdio.h>

/***************************
 *                         *
 *  QUICK SORT             *
 *                         *
 *    a : array(float)     *
 *  idx : array(int)       *
 *    n : number of array  *
 *                         *
 *   T.KOBAYASHI  88/09/26 *
 *                         *
 ***************************/

static void
q_sort(a, idx, is, ie)
     float *a, *idx;
     int    is, ie;
{

  float  x, w, iw;
  int    i, j;

  i = is;
  j = ie;

  x = a[(is + ie) / 2];

  while (i <= j) {

    while (a[i] < x)
      i++;
    while (x < a[j])
      j--;

    if (i <= j) {
      w = a[i];
      a[i] = a[j];
      a[j] = w;
      iw = idx[i];
      idx[i] = idx[j];
      idx[j] = iw;
      i++;
      j--;
    }
  }

  if (is < j)
    q_sort(a, idx, is, j);
  if (i < ie)
    q_sort(a, idx, i, ie);
}


void 
sort(a, idx, n)
     float  *a, *idx;
     int     n;
{
  int     i;

  for (i = 0; i < n; i++)
    idx[i] = (float) i;

  q_sort(a, idx, 0, n - 1);
}


