/******************************************************************
**                                                               **
**      File Name : rwfile.c                                     **
**                                                               **
**              Data File Read / Write Routines                  **
**                for SATELITE Basic Library                     **
**                                                               **
**                                      Coded by T.Kobayashi     **
**                                                               **
******************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include <stdio.h>
#include <string.h>

#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#define  max( x , y )  (((x)<(y))?(y):(x))


/***** Local Functions *****/
static void Iswap    _ANSI_ARGS_((unsigned char *data));
static void Fswap    _ANSI_ARGS_((unsigned char *data));
static void PC_head  _ANSI_ARGS_((h_type *hdr));
static void PC_data  _ANSI_ARGS_((float *data, int d_point));

static int  cpu_type _ANSI_ARGS_((/* no args */));

void
m_file(f_name)
    char           *f_name;
    /*************************************
      Make New File
      *************************************/
{
  
  char            buffer[1024];
  int             fp, count;
  
  for (count = 0; count < 1024; count++)
    buffer[count] = (char) 0;
  
  /* File Creat  mode -> 644     */
  /* ( Owner : Group : User  )   */
  /* ( r w x : r w x : r w x )   */
  /* ( 1 1 0 : 1 0 0 : 1 0 0 )   */
  fp = open(f_name, O_RDWR | O_CREAT | O_TRUNC, 0644);
  
  write(fp, buffer, 1024);
  
  close(fp);
}



int
r_file(s_blk, num_blk, f_name, data)
    int             s_blk, num_blk;
    char           *f_name;
    char           *data;
    /*********************************************
      Read from File( Low Level : Type 1  ) 
      input      s_blk   : Start  Record No 
      num_blk : Number of Record 
      f_name  : File Name
      
      output     data    : Read Data 
      
      return     : Number of Read Record 
      **********************************************/
{
  int             fd;
  long            ll = 0;
  int             read_blk, count, point;
  char            buff[REC_SIZE];
  
  
  if ((fd = open(f_name, O_RDONLY)) < 0) {
    return (-1);
  }
  read_blk = 0;
  
  ll = s_blk * REC_SIZE;
  lseek(fd, ll, 0);
  
  while (read_blk < num_blk) {
    for (count = 0; count <= REC_SIZE - 1; count++)
      buff[count] = 0x00;
    if (read(fd, buff, REC_SIZE) != REC_SIZE)
      break;
    point = read_blk * REC_SIZE;
    for (count = 0; count <= REC_SIZE - 1; count++)
      data[point + count] = buff[count];
    ++read_blk;
  }
  
  close(fd);
  
  return (read_blk);
}


int
w_file(s_blk, num_blk, f_name, data)
    int             s_blk, num_blk;
    char           *f_name;
    char           *data;
    /*************************************************
      Write to File( Low Level : Type 1 )
      
      input	s_blk    : Start Record No
      num_blk  : Number of Write Record 
      f_name   : File Name
      data     : Write Data 
      
      return : Number of Write Record 
      *************************************************/
{
  int             fd;
  long            ll = 0;
  int             write_blk, count, point;
  char            buff[REC_SIZE + 1];
  
  
  if ((fd = open(f_name, O_RDWR)) < 0) {
    return (-1);
  }
  write_blk = 0;
  
  ll = (s_blk) * REC_SIZE;
  lseek(fd, ll, 0);
  
  while (write_blk < num_blk) {
    point = write_blk * REC_SIZE;
    for (count = 0; count < REC_SIZE; count++)
      buff[count] = data[point + count];
    if (write(fd, buff, REC_SIZE) != REC_SIZE)
      break;
    ++write_blk;
  }
  
  close(fd);
  
  return (write_blk);
}


void
stor_init(f_name, type)
    char           *f_name;
    int             type;
    /*************************************************************
      SATELITE File Initialize 
      input	f_name	: File Name 
      type    : CPU type  0 - 680x0 or SPARC (EWS)
      1 - 80x86 (PC)
      **************************************************************/
{
  h_type          head;
  int             y, m, d;
  
  
  /* Read Header from file .. */
  load_header(f_name, &head);
  
  head.type_flag = (short) type;	/* Default = 0 : UNIX Format */
  head.data_flag = (short) 0;
  
  getusername(head.opr_name, sizeof(head.opr_name));
  
  get_date(&y, &m, &d);
  head.date[0] = (short) y;
  head.date[1] = (short) m;
  head.date[2] = (short) d;
  
  head.rec_leng = 0;
  head.rec_num = 0;
  head.data_num = 0;
  
  /* Write Header */
  stor_header(f_name, &head);
}




int
stor_data(data, d_point, f_name, numb)
    int             numb, d_point;
    float          *data;
    char           *f_name;
    /****************************************************
      Write to SATELITE File
      input	data	: Write Data 
      d_point : Data Point
      f_name  : File Name 
      numb    : Write Block No 
      *****************************************************/
{
  h_type          head;
  int             rec_leng, rec_num, data_num, s_blk, write_blk;
  
  /* Read Header Block */
  load_header(f_name, &head);
  
  if (head.type_flag != cpu_type()) {
    PC_data(data, d_point);
  }
  rec_leng = head.rec_leng;
  rec_num = head.rec_num;
  data_num = head.data_num;
  
  if (data_num == 0) {
    data_num = d_point;
    rec_leng = d_point / 64;
    if (d_point % 64 != 0)
      ++rec_leng;
  }
  if (data_num != d_point)
    return (-2);
  
  s_blk = (numb-1)* rec_leng + 4;
  
  write_blk = w_file(s_blk, rec_leng, f_name, (char *) data);
  if (write_blk != rec_leng)
    return (-1);
  
  rec_num = max(rec_num, numb);
  head.rec_leng = rec_leng;
  head.rec_num = rec_num;
  head.data_num = data_num;
  
  stor_header(f_name, &head);
  
  if (head.type_flag != cpu_type()) {
    PC_data(data, d_point);
  }
  
  return( d_point );
}



int
load_data(data, f_name, numb)
    int             numb;
    float          *data;
    char           *f_name;
    /****************************************************
      Read Data from SATELITE File
      input	f_name  : File Name
      numb    : Read Block No
      
      output	data    : Read Data
      
      return  : Data Point
      *****************************************************/
{
  h_type          head;
  int             rec_leng, rec_num, data_num, s_blk, read_blk;
  
  /* Read Header Block */
  load_header(f_name, &head);
  
  rec_leng = head.rec_leng;
  rec_num = head.rec_num;
  data_num = head.data_num;
  
  if (syscom.buff_leng == 0)
    syscom.buff_leng = 4096;
  if (data_num > syscom.buff_leng)
    return (-2);
  
  s_blk = (numb-1) * rec_leng + 4;
  
  read_blk = r_file(s_blk, rec_leng, f_name, (char *)data);
  if (read_blk != rec_leng)
    return (-1);
  
  if (head.type_flag != cpu_type()) {
    PC_data(data, data_num);
  }
  return (data_num);
}



void
stor_header(f_name, head)
    char           *f_name;
    h_type         *head;
    /****************************************************
      Write Header to SATELITE Data File
      input	f_name  : File Name 
      head    : Header Information 
      ***************************************************/
{
  
  if (head->type_flag != cpu_type()) {
    PC_head(head);
  }
  w_file(0, 1, f_name, (char *) head);
  
  if (head->type_flag != cpu_type()) {
    PC_head(head);
  }
}



int
load_header(f_name, head)
    char           *f_name;
    h_type         *head;
    /****************************************************
      Read Header to SATELITE Data File
      input	f_name  : File Name 
      head    : Header Information 
      **************************************************/
{
  
  if (r_file(0, 1, f_name, (char *) head) == -1)
    return (-1);
  
  if (head->type_flag != cpu_type()) {
    PC_head(head);
  }
  return (0);
  
}



/**********************************
 ***********************************
 **                               **
 **        Local Functions        **
 **                               **
 ***********************************
 **********************************/

static void
Iswap(data)
    unsigned char  *data;
    /**********************************
     *   A|B                           *
     *               Type of short     *
     *   B|A                           *
     **********************************/
{
  unsigned char   temp;
  
  temp = data[0];		/* temp = A */
  data[0] = data[1];	/* A = B    */
  data[1] = temp;		/* B = temp */
}


static void
Fswap(data)
    unsigned char  *data;
    /**********************************
     *   A|B|C|D                       *
     *                Type of float    *
     *   D|C|B|A                       *
     **********************************/
{
  unsigned char   temp;
  
  temp = data[0];		/* temp = A */
  data[0] = data[3];	/* A = D    */
  data[3] = temp;		/* D = temp */
  temp = data[1];		/* temp = B */
  data[1] = data[2];	/* B = C    */
  data[2] = temp;		/* C = temp */
  
}


static void
PC_data(data, d_point)
    float          *data;
    int             d_point;
{
  int             i;
  float           temp;
  
  for (i = 0; i < d_point; i++) {
    temp = data[i];
    Fswap((unsigned char *) &temp);
    data[i] = temp;
  }
  
}


static void
PC_head(hdr)
    h_type         *hdr;
{
  
  Iswap((unsigned char *) &hdr->type_flag);
  Iswap((unsigned char *) &hdr->data_flag);
  Iswap((unsigned char *) &hdr->date[0]);
  Iswap((unsigned char *) &hdr->date[1]);
  Iswap((unsigned char *)	&hdr->date[2]);
  Fswap((unsigned char *) &hdr->samf);
  Iswap((unsigned char *) &hdr->rec_leng);
  Iswap((unsigned char *)	&hdr->rec_num);
  Iswap((unsigned char *) &hdr->data_num);
  
}

/* LITTLE_ENDIAN : TRUE */
/* BIG_ENDAIN    : FALSE */
static int
cpu_type()
{
  short i = 0x0001;
  char *c = (char *)&i;
  return (int)c[0];
}
