/******************************************************************
 **                                                               **
 **      File Name : usr_info.c                                   **
 **                                                               **
 **                 User & Date Information                       **
 **                for SATELLITE Basic Library                    **
 **                                                               **
 **                                      Coded by T.Kobayashi     **
 **                                                               **
 ******************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "SL_macro.h"

#ifdef HAVE_UNISTD_H
#include "unistd.h"
#endif
#ifdef HAVE_SYS_TYPES_H
#include "sys/types.h"
#endif
#include <pwd.h>


char *
getusername(name, siz)
     char  *name;
     int    siz;
{
  uid_t           uid = getuid();
  struct passwd  *pwd;

  pwd = getpwuid(uid);
  if ( pwd != NULL ) {
    strncpy(name, pwd->pw_name, siz-1);
    name[siz-1] = '\0';
  } else {
    char *tmpbuf = getenv("USER");
    if ( tmpbuf != NULL )
      strncpy(name, tmpbuf, siz-1);
    else
      name[0] = '\0';
  }
  return name;
}


char *
gethomedir(dir, siz)
     char  *dir;
     int    siz;
{
  uid_t           uid = getuid();
  struct passwd  *pwd;

  pwd = getpwuid(uid);
  if ( pwd != NULL ) {
    strncpy(dir, pwd->pw_dir, siz - 1);
    dir[siz - 1] = '\0';
  } else {
    char *tmpbuf = getenv("HOME");
    if ( tmpbuf != NULL )
      strncpy(dir, tmpbuf, siz-1);
    else
    dir[0] = '\0';
  }
  return dir;
}


void
get_date(year, month, day)
     int  *year, *month, *day;
     /*****************************
      * Get Date (Local)          *
      *****************************/
{
  struct tm  *times;
#ifdef _TIME_T
  time_t      gtime;
#else
  long        gtime;
#endif

  time(&gtime);
  times = localtime(&gtime);
  *year = times->tm_year;
  *month = times->tm_mon + 1;
  *day = times->tm_mday;
}


void
get_time(hour, minute, second)
     int  *hour, *minute, *second;
{
  struct tm  *times;
#ifdef _TIME_T
  time_t      gtime;
#else
  long        gtime;
#endif

  time(&gtime);
  times = localtime(&gtime);
  *hour = times->tm_hour;
  *minute = times->tm_min;
  *second = times->tm_sec;
}
