/*****************************************************************************

                      NCSDEF : CONSTANTS DEFINITION TABEL


    $Id: ncsdef.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _NCSDEF_H_
#define _NCSDEF_H_

/* for SATELLITE */
#define SATELLITE       1

/* NCSPP SYSTEM */
#define  NCS_MDL_EXTN     "mdl"     /* file extension of model description */
#define  NCS_MDL_EXTN_OLD "MDL"     /* file extension of model description */
#define  NCS_SPF_EXTN     "c"       /* file extension of simulation program */
#define  NCS_OBJ_EXTN     "o"       /* file extension of object program */
#define  NCS_HDF_EXTN     "h"       /* file extension of simulation header */
#define  NCS_ERR_EXTN     "err"     /* file extension of error file */
#define  NPP_FLOAT_FLAG   '1'       /* DATA TYPE FLAG */
#define  NPP_LONG_FLAG    '2'       /* DATA TYPE FLAG */
#define  NPP_XINP_YES     1         /* FLAG FOR EXTERNAL INPUT */
#define  NPP_XINP_NO      0         /* FLAG FOR EXTERNAL INPUT */

/* SIMULATION CONDITION FILE */
#define  NCS_MAT_EXTN   "mat"     /* file extension of simulation condition */
#define  NCS_PRM_EXTN   "prm"     /* file extension of simulation condition */
#define  NCS_XIN_EXTN   "xin"     /* file extension of simulation condition */
#define  NCS_XFP_EXTN   "xfp"     /* file extension of simulation condition */
#define  NCS_OUT_EXTN   "out"     /* file extension of simulation condition */
#define  NCS_DLY_EXTN   "dly"     /* file extension of simulation condition */
#define  NCS_SCFN_FNAME "SCFN.NCS"/* simulation condition file name file */
#define  NCS_SCF_DIR    ".NCSSCF/"/* directory for simulation condition file */
/*#define  NCS_SCF_EOF    NULL	  */

/* NCS PREPROCESSOR and LINKER */
#define  NCS_PREPRO     	"npp"
#define  NCS_PREPRO_FILTER     	"nspp.sh"
#define  NCS_PREPRO_OLD 	"NcsPrepro"
#define  NCS_LINKER     	"nlinker.sh"
#define  NCS_TMP_MODEL_FILE	"MODEL.TMP"

/* SIMULATION CONDITION FILE */
#define  NCS_SCF_EOF      '\0'	/* END OF FILE MARK 
				     FOR SIMULATION CONDITION FILES */
#define  NCS_SCF_ERASED   '0'	/* ERASED MARK
				     FOR SIMULATION CONDITION FILES */
#define  NCS_DYNMC_FLAG   '1'   /* FLAG FOR SIMULATION MODE */
#define  NCS_STATC_FLAG   '2'   /* FLAG FOR SIMULATION MODE */
#define  NCS_XFP_MAX      5     /* MAXIMUM NUMBER 
				     OF EXTERNAL INPUT FUNCTION PARAMETER */
#define  NCS_XF_MAX       10    /* MAXIMUM NUMBER OF EXTERNAL INPUT FUNCTION */
#define  NCS_MONI_NVAR    4     /* MAXIMUM NUMBER OF MONITERING VARIABLE */
#define  NCS_MONI_NO      '0'   /* NO MONITERING */
#define  NCS_MONI_VLONLY  '1'   /* VALUE ONLY */
#define  NCS_DATA_FNAME   22    /* LENGTH OF DATA FILE NAME + EOS */
#define  NCS_XSCALE_MIN   0.    /* MINIMUM X-COORDINATE SCALE */

/* Size Definition */
#define  SCF_NAME_LEN      33      /* LENGTH OF NAME + EOS */
#define  SCF_NAME_WID      36     /* LENGTH OF NAME WITH ID NUMBER + EOS */
#define  NCS_BUF_NAME_LEN  32     /* Length of Buffer Name */
#define  NAME_SIZE         32     /* LENGTH OF NAME + EOS */
#define  SEG_SIZE          524288 /* SIZE OF SEGMENT */
#define  FLOAT_SIZE        4      /* byte */
#define  OFFSET            636    /* byte */
#define  NCS_MDL_MAX       100    /* Maximum number of Module */

/* NCS System */
#define  UPPER_LEFT     0         /* LOCATION OF GRAPH */
#define  UPPER_RIGHT    1         /* LOCATION OF GRAPH */
#define  LOWER_LEFT     2         /* LOCATION OF GRAPH */
#define  LOWER_RIGHT    3         /* LOCATION OF GRAPH */

#define  ISPP_BUFF_MIN  4         /* MINIMUM NUMBER OF ISPP BUFFER */
#define  ISPP_BUFF_MAX  255        /* MAXIMUM NUMBER OF ISPP BUFFER */
#define  SEG_BUFFER     0x8000    /* for ISPP new version */
#define  SEG_SYSCOM     0x9000    /* for ISPP new version */

/* FLAG DEFINITION */
#define OUTPUT_INIT         'I'
#define DELAY_INIT_SET      'S'
#define CALCULATE           'C'

#define DELAY_INIT_AUTO_SET 'A'
#define DELAY_INIT_FIXD_SET 'F'

/* OUTPUT BUFFER INFOMATION */
#define OUT_BUFF_OUT_TYPE	'1'	/* from output statement       */
#define OUT_BUFF_EXIN_TYPE	'2'     /* from exinput statement      */
#define OUT_BUFF_OBS_TYPE	'3'     /* from observable statement   */
#define OUT_MONITOR_TYPE	'4'     /* moniter mode                */
#define OUT_FILE_TYPE		'5'     /* output data file            */
#define OUT_BUFF_SIZE_TYPE	'6'     /* specified max output buffer */
#define OUT_NO_TYPE		'7'     /* no assign                   */

/******** for Old NCS Priprocessor ********/
/* NCS MODULE */
#define  NCS_MD_NET     1         /* NETWORK module */
#define  NCS_MD_CELL    2         /* CELL module */
#define  NCS_MD_SYNP    3         /* SYNAPSE module */
#define  NCS_MD_GAP     4         /* GAP module */
#define  NCS_MD_XINP    5         /* EXINPUT module */

/* NCS STATEMENT */
#define  NCS_ST_TYPE    1         /* 'type'       statement */
#define  NCS_ST_NAME    2         /* 'name'       statement */
#define  NCS_ST_CMNT    3         /* 'comment'    statement */
#define  NCS_ST_MODE    4         /* 'mode'       statement */
#define  NCS_ST_CELL    5    	  /* 'cell'       statement */
#define  NCS_ST_SYNP    6         /* 'synapse'    statement */
#define  NCS_ST_GAP     7         /* 'gap'        statement */
#define  NCS_ST_DEF     8         /* 'define'     statement */
#define  NCS_ST_PRM     9         /* 'parameter'  statement */
#define  NCS_ST_CNCT    10        /* 'connection' statement */
#define  NCS_ST_INP     11        /* 'input'      statement */
#define  NCS_ST_OUT     12        /* 'output'     statement */
#define  NCS_ST_XINP    13        /* 'exinput'    statement */
#define  NCS_ST_OBS     14        /* 'observable' statement */
#define  NCS_ST_INIT    15        /* 'initial'    statement */
#define  NCS_ST_FUNC    16        /* 'function'   statement */
#define  NCS_ST_DLY     17        /* 'delay'      statement */

/* NCS STATEMENT MACRO */
#define  NCS_MC_FOR     1     /* 'FOR' macro in 'connection' statement */
#define  NCS_MC_NEXT    2     /* 'NEXT' statement ( 'FOR' macro ) */
#define  NCS_MC_SUM     1     /* 'SUM' macro in 'connection' statement */

/* SYSTEM DEFINED VARIABLE */
#define  NCS_SYS_TIME   1     /* SIMULATION TIME */
#define  NCS_SYS_CN     2     /* COMPONENT NUMBER */
#define  NCS_SYS_PRECN  3     /* COMPONENT NUMBER OF PRESYNAPTIC COMPONENT */
#define  NCS_SYS_POSCN  4     /* COMPONENT NUMBER OF POSTSYNAPTIC COMPONENT */
#define  NCS_SYS_POSOUT 5     /* OUTPUT VALUE OF POSTSYNAPTIC COMPONENT */
#define  NCS_SYS_DFLT   6     /* FOR NON SYSTEM DEFINED VARIABLE */

/* NCS LIBRARY */
#define  NCS_LIB_PULSE  1     /* PULSE FUNCTION */
#define  NCS_LIB_RAMP   2     /* RAMP FUNCTION */
#define  NCS_LIB_RCAB   3     /* RATE CONSTANT OF IONIC CURRENT */
#define  NCS_LIB_SIGMD  4     /* SIGMOID FUNCTION */
#define  NCS_LIB_INTG   5     /* INTEGRATION */
#define  NCS_LIB_DFLT   6     /* FOR NON NCS LIBRARY */

/* MSC MATH LIBRARY */
#define  MATH_LIB_DFLT  21    /* FOR NON MSC MATH LIBRARY */

/* NCSPP SIZE DEFINITION */
#define  NPP_BUFF_SIZE  200  /* SIZE OF STORAGE BUFFER FOR MODEL DESCRIPTION */
#define  NPP_SUBB_SIZE  300  /* SIZE OF STORAGE BUFFER FOR MODEL DESCRIPTION
                                ( INCLUDES TAB, LF, CR AND SPACE )           */
#define  NPP_TYPE_LEN   11    /* LENGTH OF MODULE TYPE + EOS */
#define  NPP_NAME_LEN   9     /* LENGTH OF NAME + EOS */
#define  NPP_INUM_LEN   6     /* LENGTH OF INTEGER NUMBER + EOS */
#define  NPP_NAME_WID   12    /* LENGTH OF NAME WITH ID NUMBER + EOS */
#define  NPP_VAL_LEN    16    /* LENGTH OF VALUE + EOS */
#define  NPP_COND_LEN   30    /* LENGTH OF CONDITION + EOS */
#define  NPP_OPE_LEN    3     /* LENGTH OF OPERATOR + EOS */

/* for ADAPTIVE INTEGRATION */
#define  NCS_ADP_t			"NcsTime"
#define  NCS_ADP_y			"Ncs_y"
#define  NCS_ADP_dy			"Ncs_dy"
#define  NCS_ADP_ARG		" NcsTime, Ncs_y, Ncs_dy "

#define  STRTANA	0
#define  INITVAR	1
#define  EXPRESS	2
#define  OLD_VAR	3
#define  INTEGRL	4

/* TEMPORARY FILE NAME */
#define  TMPDEF		"ncsdef.tmp"
#define  TMPHEAD	"ncshead.tmp"
#define  TMPMID		"ncsmid.tmp"
#define  TMPTAIL	"ncstail.tmp"
#define  TMPUND		"ncsund.tmp"
#define  TMPINI		"ncsini.tmp"
#define  TMPPRM		"ncsprm.tmp"
#define  TMPDLY		"ncsdly.tmp"
#define  TMPNLIST       "nlist.tmp"

/* DEFAULTS COMMAND */
#define  COMMANDLEN     100
#define  EDITOR         "vi"

#endif /* _NCSDEF_H */
