/*****************************************************************************

                            HEADER FILE FOR NCSSMAIN.C

    $Id: ncssmain.h,v 1.1.1.1 2004/03/26 14:57:15 orrisroot Exp $

*****************************************************************************/

#ifndef _NCSSMAIN_H_
#define _NCSSMAIN_H_

/*** GLOBAL VARIABLES ***/
extern char     ncsg_mode;        /* simulation mode                       */
extern char     ncsg_strflg;      /* flag for storing data                 */
extern char     ncsg_strfile[];   /* file name for storing data            */
extern int      ncsg_nxinc;       /* the number of components which 
                                                    have an external input */
extern int      ncsg_nstrd;       /* the number of data stored 
				     			  into ISPP buffer */
extern int      ncsg_cdpoint;     /* current data point                    */

extern double   NCS_TIME;         /* simulation timer                      */
extern double   ncsg_calstep;     /* calculation step                      */
extern int      ncsg_cell;
extern double   ncsg_relerr;
extern int      ncsg_neqn;
extern char     ncsg_intg_method;
extern char     ncsg_delay_flag;

extern double   (*ncsg_xinfaddr[]) (); 
     				  /* external input function address table */
extern struct xin_info ncsg_xindata[]; 
                                  /* external input information            */
extern struct xfp_info ncsg_xfpdata[]; 
                                  /* external input function information   */

extern int      ncsg_ntout;
extern int      ncsg_ncout[];
extern double  *ncsm_outptr[];
extern double  *ncsm_subptr[];

/*** FUNCTIONS ***/
/* C source of model */
extern void     NETWORK		_ANSI_ARGS_(( double NcsTime, 
					      double **Ncs_y,
					      double **Ncs_dy ));
extern void     ncsf_constset	_ANSI_ARGS_(( void ));

#endif /* _NCSSMAIN_H_ */
